/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat.fluid.cosmopolitan;

import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class EDIceCreamFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final ResourceLocation tubStillTexture;
    private final ResourceLocation tubFlowingTexture;
    private static boolean cosmopolitanLoaded = false;

    public EDIceCreamFluidType(String texture) {
        super(FluidType.Properties.create());
        this.stillTexture = new ResourceLocation("extravagantdelight", "block/cosmopolitan/" + texture + "_ice_cream");
        this.flowingTexture = new ResourceLocation("extravagantdelight", "block/cosmopolitan/" + texture + "_ice_cream");
        this.tubStillTexture = new ResourceLocation("extravagantdelight", "block/cosmopolitan/tub/" + texture + "_ice_cream");
        this.tubFlowingTexture = new ResourceLocation("extravagantdelight", "block/cosmopolitan/tub/" + texture + "_ice_cream");
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return EDIceCreamFluidType.isInTubContext() ? EDIceCreamFluidType.this.tubStillTexture : EDIceCreamFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return EDIceCreamFluidType.isInTubContext() ? EDIceCreamFluidType.this.tubFlowingTexture : EDIceCreamFluidType.this.flowingTexture;
            }
        });
    }

    private static boolean isInTubContext() {
        if (!cosmopolitanLoaded) {
            return false;
        }
        try {
            Class<?> cosmoFluidClass = Class.forName("com.gumillea.cosmopolitan.common.fluid.CosmoIceCreamFluidType");
            Method method = cosmoFluidClass.getDeclaredMethod("isInTubContext", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        try {
            Class.forName("com.gumillea.cosmopolitan.common.fluid.CosmoIceCreamFluidType");
            cosmopolitanLoaded = true;
        }
        catch (ClassNotFoundException e) {
            cosmopolitanLoaded = false;
        }
    }
}

