/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block;

import java.util.Collections;
import java.util.List;
import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MuscadineCropBlock
extends Block
implements BonemealableBlock {
    public static final IntegerProperty AGE = IntegerProperty.m_61631_((String)"age", (int)0, (int)5);
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final VoxelShape POST = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape NORTH_POST = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)6.0);
    private static final VoxelShape SOUTH_POST = Block.m_49796_((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_POST = Block.m_49796_((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape WEST_POST = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0);

    public MuscadineCropBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE, NORTH, SOUTH, EAST, WEST});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = POST;
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)NORTH_POST);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)SOUTH_POST);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)EAST_POST);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)WEST_POST);
        }
        return shape;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_().m_122479_()) {
            return (BlockState)state.m_61124_((Property)this.getProperty(facing), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, facingPos)));
        }
        return super.m_7417_(state, facing, facingState, world, currentPos, facingPos);
    }

    private BooleanProperty getProperty(Direction direction) {
        switch (direction) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    private boolean canConnectTo(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        return state.m_204336_(BlockTags.f_13039_);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!world.m_8055_(pos.m_121945_(direction)).m_204336_(BlockTags.f_13039_)) continue;
            return true;
        }
        return false;
    }

    public void onNeighborChange(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!world.m_5776_()) {
            BlockState neighborState = world.m_8055_(fromPos);
            if (neighborState.m_204336_(BlockTags.f_13039_)) {
                if (!this.m_7898_(state, (LevelReader)world, pos)) {
                    world.m_46961_(pos, false);
                } else {
                    world.m_7731_(pos, this.updateShape(state, world, pos), 3);
                }
            } else {
                world.m_7731_(pos, this.updateShape(state, world, pos), 3);
            }
        }
        super.m_6861_(state, world, pos, block, fromPos, isMoving);
    }

    private BlockState updateShape(BlockState state, Level world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos.m_122012_())))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos.m_122019_())))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos.m_122029_())))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos.m_122024_())));
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            world.m_7731_(pos, this.updateShape(state, world, pos), 3);
            if (!world.m_5776_()) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    BlockPos adjacentPos = pos.m_121945_(direction);
                    BlockState adjacentState = world.m_8055_(adjacentPos);
                    if (!adjacentState.m_204336_(BlockTags.f_13039_)) continue;
                    world.m_7731_(adjacentPos, adjacentState, 3);
                }
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_()) && !world.m_5776_()) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos adjacentPos = pos.m_121945_(direction);
                BlockState adjacentState = world.m_8055_(adjacentPos);
                if (!adjacentState.m_204336_(BlockTags.f_13039_)) continue;
                world.m_7731_(adjacentPos, adjacentState, 3);
            }
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 5;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (age < 5 && random.m_188503_(5) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
        if (age == 5 && random.m_188503_(10) == 0) {
            this.trySpread(level, pos, random);
        }
    }

    private void trySpread(ServerLevel world, BlockPos pos, RandomSource random) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos fencePos;
            if (!(random.m_188501_() < 0.25f) || !world.m_8055_(fencePos = pos.m_121945_(direction)).m_204336_(BlockTags.f_13039_) || world.m_8055_(fencePos).m_60734_() instanceof MuscadineCropBlock) continue;
            world.m_7731_(fencePos, this.m_49966_(), 3);
        }
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.m_61143_((Property)AGE) < 5;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        int newAge = Math.min(5, (Integer)state.m_61143_((Property)AGE) + 1 + random.m_188503_(2));
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newAge)), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if ((Integer)state.m_61143_((Property)AGE) == 5 && !world.m_5776_()) {
            int grapeCount = 1 + world.f_46441_.m_188503_(2);
            MuscadineCropBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.MUSCADINE_GRAPES.get(), grapeCount));
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
            world.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public List<ItemStack> getDrops(BlockState state, LootContext.Builder builder) {
        return Collections.emptyList();
    }
}

