/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.custom_blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EDJarBlock
extends Block {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private final Supplier<Item> jarItem;

    public EDJarBlock(BlockBehaviour.Properties properties, Supplier<Item> jarItem) {
        super(properties);
        this.jarItem = jarItem;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL, FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.jarItem.get(), this.getJarCount(state));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        if (!level.f_46443_) {
            int count = this.getJarCount(state);
            ItemStack drop = new ItemStack((ItemLike)this.jarItem.get(), count);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop));
        }
    }

    private int getJarCount(BlockState state) {
        switch ((Integer)state.m_61143_((Property)LEVEL)) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
        }
        return 1;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int lvl = (Integer)state.m_61143_((Property)LEVEL);
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return EDJarBlock.rotateShape(Direction.NORTH, dir, switch (lvl) {
            case 0 -> Block.m_49796_((double)5.5, (double)0.0, (double)9.0, (double)10.5, (double)7.0, (double)14.0);
            case 1 -> Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)14.0), (VoxelShape)Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)14.0, (double)7.0, (double)14.0));
            case 2 -> Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)14.0, (double)7.0, (double)14.0), Block.m_49796_((double)5.5, (double)0.0, (double)2.0, (double)10.5, (double)7.0, (double)7.0)});
            case 3 -> Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)7.0, (double)7.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)9.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)7.0), Block.m_49796_((double)2.0, (double)0.0, (double)9.0, (double)7.0, (double)7.0, (double)14.0), Block.m_49796_((double)9.0, (double)0.0, (double)9.0, (double)14.0, (double)7.0, (double)14.0)});
            default -> Shapes.m_83144_();
        });
    }

    private static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        int times = (to.m_122416_() - from.m_122416_() + 4) % 4;
        for (int i = 0; i < times; ++i) {
            buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
            });
            buffer[0] = buffer[1];
            buffer[1] = Shapes.m_83040_();
        }
        return buffer[0];
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack held = player.m_21120_(hand);
        int current = (Integer)state.m_61143_((Property)LEVEL);
        if (player.m_6144_()) {
            if (current > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(current - 1)), 3);
                this.giveJar(level, pos, player);
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.7f, 1.0f);
            } else {
                this.giveJar(level, pos, player);
                level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.7f, 1.0f);
                level.m_7471_(pos, false);
            }
            return InteractionResult.CONSUME;
        }
        if (!held.m_41619_() && held.m_41720_() == this.jarItem.get() && current < 3) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(current + 1)), 3);
            if (!player.m_7500_()) {
                held.m_41774_(1);
            }
            level.m_5594_(null, pos, SoundEvents.f_11986_, SoundSource.BLOCKS, 0.7f, 1.0f);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private void giveJar(Level level, BlockPos pos, Player player) {
        ItemStack jar = new ItemStack((ItemLike)this.jarItem.get());
        if (!player.m_36356_(jar)) {
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, jar));
        }
    }
}

