/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.magicvt.extravagantdelight.compat.SorbetMakerCategory;
import net.magicvt.extravagantdelight.compat.StompingVatCategory;
import net.magicvt.extravagantdelight.core.registry.item.ModItems;
import net.magicvt.extravagantdelight.recipe.ModRecipes;
import net.magicvt.extravagantdelight.recipe.SorbetMakerRecipe;
import net.magicvt.extravagantdelight.recipe.StompingVatRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@JeiPlugin
public class ExtravagantDelightJEIPlugin
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("extravagantdelight", "jei_plugin");
    private static final List<Supplier<Item>> INFO_ITEMS = List.of(() -> ModItems.STARFRUIT.get(), () -> ModItems.QUINCE.get(), () -> ModItems.SLOE_BERRIES.get(), () -> ModItems.BARLEY.get(), () -> ModItems.HOPS.get(), () -> ModItems.RHUBARB.get(), () -> ModItems.MUSCADINE_GRAPES.get());

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new StompingVatCategory(registration.getJeiHelpers().getGuiHelper()), new SorbetMakerCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        for (Supplier<Item> itemSupplier : INFO_ITEMS) {
            Item item = itemSupplier.get();
            ResourceLocation key = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item));
            String translationKey = "jei.extravagantdelight." + key.m_135815_() + ".desc";
            registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)translationKey)});
        }
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)ModItems.LUSH_MANGO.get()), new ItemStack((ItemLike)ModItems.GREEN_MANGO.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.m_237115_((String)"jei.extravagantdelight.mango.desc")});
        ClientPacketListener connection = Minecraft.m_91087_().m_91403_();
        if (connection != null) {
            List<StompingVatRecipe> vatRecipes = connection.m_105141_().m_44013_((RecipeType)ModRecipes.STOMPING_VAT_TYPE.get()).stream().map(r -> r).toList();
            System.out.println("DEBUG JEI: cargadas " + vatRecipes.size() + " recetas de Stomping Vat");
            registration.addRecipes(StompingVatCategory.JEI_TYPE, vatRecipes);
            List<SorbetMakerRecipe> sorbetRecipes = connection.m_105141_().m_44013_((RecipeType)ModRecipes.SORBET_MAKER_TYPE.get()).stream().map(r -> r).toList();
            System.out.println("DEBUG JEI: cargadas " + sorbetRecipes.size() + " recetas de Sorbet Maker");
            registration.addRecipes(SorbetMakerCategory.JEI_TYPE, sorbetRecipes);
        }
    }
}

