/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat.fluid.brewinandchewin;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class BrewFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;

    public BrewFluidType(String texture) {
        super(BrewFluidType.createProperties());
        this.stillTexture = new ResourceLocation("extravagantdelight", "block/brewinandchewin/" + texture + "_still");
        this.flowingTexture = new ResourceLocation("extravagantdelight", "block/brewinandchewin/" + texture + "_flow");
    }

    public BrewFluidType(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    private static FluidType.Properties createProperties() {
        return FluidType.Properties.create().density(1000).viscosity(1000);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return BrewFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return BrewFluidType.this.flowingTexture;
            }

            public int getTintColor() {
                return -1;
            }
        });
    }
}

