/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.compat.fluid.hearthandharvest;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;

public class WineFluidType
extends FluidType {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;

    public WineFluidType(String texture) {
        super(WineFluidType.createProperties());
        this.stillTexture = new ResourceLocation("extravagantdelight", "block/hearthandharvest/" + texture + "_wine_still");
        this.flowingTexture = new ResourceLocation("extravagantdelight", "block/hearthandharvest/" + texture + "_wine_flow");
    }

    public WineFluidType(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_));
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
    }

    private static FluidType.Properties createProperties() {
        return FluidType.Properties.create().density(1000).viscosity(1000);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return WineFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return WineFluidType.this.flowingTexture;
            }

            public int getTintColor() {
                return -1;
            }
        });
    }
}

