/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.magicvt.extravagantdelight.core.registry.block.StompingVatBlock;
import net.magicvt.extravagantdelight.core.registry.block.entity.StompingVatBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;

public class StompingVatBlockEntityRenderer
implements BlockEntityRenderer<StompingVatBlockEntity> {
    private final ItemRenderer itemRenderer;

    public StompingVatBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
    }

    public void render(StompingVatBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        float progress = Math.min(1.0f, (float)blockEntity.getStandTicks() / 200.0f);
        this.renderItems(blockEntity, blockEntity.getItems(), poseStack, buffer, level, packedLight, packedOverlay, progress);
    }

    private void renderItems(StompingVatBlockEntity blockEntity, List<ItemStack> items, PoseStack poseStack, MultiBufferSource buffer, Level level, int packedLight, int packedOverlay, float progress) {
        if (items.isEmpty()) {
            return;
        }
        poseStack.m_85836_();
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)StompingVatBlock.FACING);
        float rotation = switch (facing) {
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 180.0f;
        };
        poseStack.m_85837_(0.5, 0.0, 0.5);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack = items.get(i);
            if (stack.m_41619_()) continue;
            poseStack.m_85836_();
            float x = 0.5f + (float)(i % 2) * 0.3f - 0.15f;
            float z = 0.5f + (float)(i / 2) * 0.3f - 0.15f;
            float y = 0.1f - 0.2f * progress;
            poseStack.m_252880_(x, y, z);
            poseStack.m_85841_(0.6f, 0.6f, 0.6f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(45.0f));
            this.itemRenderer.m_269128_(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, poseStack, buffer, level, 0);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

