/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.effect;

import net.magicvt.extravagantdelight.core.registry.sound.ModSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CannonHopEffect
extends MobEffect {
    public CannonHopEffect() {
        super(MobEffectCategory.BENEFICIAL, 4896069);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        int interval = this.getIntervalForAmplifier(amplifier);
        if (entity.f_19797_ % interval == 0) {
            this.launchPlayer(entity, amplifier);
        }
    }

    public void onEffectAdded(LivingEntity entity, int amplifier) {
        this.launchPlayer(entity, amplifier);
    }

    private int getIntervalForAmplifier(int amplifier) {
        return switch (amplifier) {
            case 0 -> 140;
            case 1 -> 120;
            case 2 -> 100;
            default -> 100;
        };
    }

    private double getLaunchPowerForAmplifier(int amplifier) {
        return switch (amplifier) {
            case 0 -> 1.0;
            case 1 -> 2.2;
            case 2 -> 4.4;
            default -> 5.0;
        };
    }

    private void launchPlayer(LivingEntity entity, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            Vec3 lookVec = entity.m_20154_();
            double launchPower = this.getLaunchPowerForAmplifier(amplifier);
            Vec3 launchVec = lookVec.m_82490_(launchPower);
            entity.m_20334_(launchVec.f_82479_, 1.5, launchVec.f_82481_);
            entity.f_19864_ = true;
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)ModSounds.HOP_CANNON.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            this.spawnSmokeBurst(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        }
    }

    private void spawnSmokeBurst(Level level, double x, double y, double z) {
        RandomSource random = level.m_213780_();
        int particleCount = 25;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double horizontalSpeed = 0.05 + random.m_188500_() * 0.15;
            double velocityX = Math.cos(angle) * horizontalSpeed;
            double velocityZ = Math.sin(angle) * horizontalSpeed;
            double velocityY = 0.1 + random.m_188500_() * 0.2;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, velocityX, velocityY, velocityZ);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

