/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.magicvt.extravagantdelight.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class SorbetMakerRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final ItemStack output;
    private final NonNullList<ItemStack> secondaryOutputs;
    private final NonNullList<CountedIngredient> ingredients;
    private final Ingredient container;

    public SorbetMakerRecipe(ResourceLocation id, ItemStack output, NonNullList<CountedIngredient> ingredients, Ingredient container, NonNullList<ItemStack> secondaryOutputs) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
        this.container = container;
        this.secondaryOutputs = secondaryOutputs;
    }

    public SorbetMakerRecipe(ResourceLocation id, ItemStack output, NonNullList<CountedIngredient> ingredients) {
        this(id, output, ingredients, Ingredient.f_43901_, (NonNullList<ItemStack>)NonNullList.m_122779_());
    }

    public boolean matches(SimpleContainer containerIn, Level level) {
        ItemStack slot;
        if (level.f_46443_) {
            return false;
        }
        ItemStack[] grid = new ItemStack[9];
        for (int i = 0; i < 9; ++i) {
            grid[i] = containerIn.m_8020_(i).m_41777_();
        }
        for (CountedIngredient ci : this.ingredients) {
            int needed = ci.count;
            for (int i = 0; i < 9 && needed > 0; ++i) {
                if (!ci.ingredient.test(grid[i])) continue;
                int take = Math.min(needed, grid[i].m_41613_());
                grid[i].m_41774_(take);
                needed -= take;
            }
            if (needed <= 0) continue;
            return false;
        }
        return this.container.m_43947_() || this.container.test(slot = containerIn.m_8020_(9));
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return this.output.m_41777_();
    }

    public ItemStack getResultItem() {
        return this.output.m_41777_();
    }

    public NonNullList<ItemStack> getSecondaryResults() {
        return this.secondaryOutputs;
    }

    public Ingredient getContainer() {
        return this.container;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList list = NonNullList.m_122779_();
        for (CountedIngredient ci : this.ingredients) {
            list.add((Object)ci.ingredient);
        }
        return list;
    }

    public NonNullList<CountedIngredient> getCountedIngredients() {
        return this.ingredients;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SORBET_MAKER_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.SORBET_MAKER_TYPE.get();
    }

    public static class CountedIngredient {
        public static final CountedIngredient EMPTY = new CountedIngredient(Ingredient.f_43901_, 1);
        public final Ingredient ingredient;
        public final int count;

        public CountedIngredient(Ingredient ingredient, int count) {
            this.ingredient = ingredient;
            this.count = count;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SorbetMakerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("extravagantdelight", "sorbet_maker");

        public SorbetMakerRecipe fromJson(ResourceLocation id, JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            NonNullList inputs = NonNullList.m_122779_();
            for (JsonElement e : ingredientsJson) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient ing = Ingredient.m_43917_((JsonElement)obj);
                int count = obj.has("count") ? GsonHelper.m_13927_((JsonObject)obj, (String)"count") : 1;
                inputs.add((Object)new CountedIngredient(ing, count));
            }
            Ingredient container = Ingredient.f_43901_;
            if (json.has("container")) {
                container = Ingredient.m_43917_((JsonElement)json.get("container"));
            }
            NonNullList secondaryOutputs = NonNullList.m_122779_();
            if (json.has("secondary_result")) {
                JsonElement secElem = json.get("secondary_result");
                if (secElem.isJsonArray()) {
                    JsonArray array = secElem.getAsJsonArray();
                    for (JsonElement elem : array) {
                        secondaryOutputs.add((Object)ShapedRecipe.m_151274_((JsonObject)elem.getAsJsonObject()));
                    }
                } else if (secElem.isJsonObject()) {
                    secondaryOutputs.add((Object)ShapedRecipe.m_151274_((JsonObject)secElem.getAsJsonObject()));
                }
            }
            return new SorbetMakerRecipe(id, output, (NonNullList<CountedIngredient>)inputs, container, (NonNullList<ItemStack>)secondaryOutputs);
        }

        public SorbetMakerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            int size = buf.readInt();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)CountedIngredient.EMPTY);
            for (int i = 0; i < size; ++i) {
                Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buf);
                int count = buf.readInt();
                inputs.set(i, (Object)new CountedIngredient(ing, count));
            }
            ItemStack output = buf.m_130267_();
            int secSize = buf.readInt();
            NonNullList secondaryOutputs = NonNullList.m_122780_((int)secSize, (Object)ItemStack.f_41583_);
            for (int i = 0; i < secSize; ++i) {
                secondaryOutputs.set(i, (Object)buf.m_130267_());
            }
            Ingredient container = Ingredient.m_43940_((FriendlyByteBuf)buf);
            return new SorbetMakerRecipe(id, output, (NonNullList<CountedIngredient>)inputs, container, (NonNullList<ItemStack>)secondaryOutputs);
        }

        public void toNetwork(FriendlyByteBuf buf, SorbetMakerRecipe recipe) {
            buf.writeInt(recipe.ingredients.size());
            for (CountedIngredient ci : recipe.ingredients) {
                ci.ingredient.m_43923_(buf);
                buf.writeInt(ci.count);
            }
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.secondaryOutputs.size());
            for (ItemStack sec : recipe.secondaryOutputs) {
                buf.m_130055_(sec);
            }
            recipe.container.m_43923_(buf);
        }
    }

    public static class Type
    implements RecipeType<SorbetMakerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "sorbet_maker";
    }
}

