/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.client;

import com.mojang.logging.LogUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.locating.IModFile;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="extravagantdelight", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ModBuiltinResourcepacks {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onAddPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        ModList.get().getModContainerById("extravagantdelight").ifPresent(container -> {
            IModFile modFile = container.getModInfo().getOwningFile().getFile();
            Path packRoot = modFile.findResource(new String[]{"resourcepacks/extravagant_coasters"});
            if (!Files.exists(packRoot, new LinkOption[0])) {
                LOGGER.warn("Resource pack not found in {}", (Object)packRoot);
                return;
            }
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.m_245429_((String)"extravagant_coasters", (Component)Component.m_237113_((String)"Extravagant Coasters"), (boolean)false, id -> new PathPackResources(id, packRoot, false), (PackType)event.getPackType(), (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack != null) {
                    consumer.accept(pack);
                    LOGGER.info("'extravagant_coasters' registered.");
                } else {
                    LOGGER.error("Error in Pack.mcmeta.");
                }
            });
        });
    }
}

