/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.item;

import com.mojang.datafixers.util.Pair;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class LollipopItem
extends Item {
    private final int maxBites;
    private final FoodProperties food;

    public LollipopItem(Item.Properties properties, FoodProperties food, int maxBites) {
        super(properties.m_41487_(1).m_41489_(food));
        this.food = food;
        this.maxBites = maxBites;
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_36324_().m_38707_(this.food.m_38744_(), this.food.m_38745_());
            if (!level.f_46443_) {
                for (Pair pair : this.food.m_38749_()) {
                    if (pair.getFirst() == null || !(level.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                    player.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
                int bites = stack.m_41784_().m_128451_("Bites") + 1;
                stack.m_41784_().m_128405_("Bites", bites);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11970_, SoundSource.PLAYERS, 0.8f, 1.0f);
                if (bites >= this.maxBites) {
                    return ItemStack.f_41583_;
                }
            }
        }
        return stack;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public boolean m_142522_(ItemStack stack) {
        int bites = stack.m_41784_().m_128451_("Bites");
        return bites > 0;
    }

    public int m_142158_(ItemStack stack) {
        int bites = stack.m_41784_().m_128451_("Bites");
        return Math.round(13.0f - 13.0f * (float)bites / (float)this.maxBites);
    }

    public int m_142159_(ItemStack stack) {
        int bites = stack.m_41784_().m_128451_("Bites");
        float ratio = (float)(this.maxBites - bites) / (float)this.maxBites;
        return Mth.m_14169_((float)(ratio / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 0));
        return super.m_7579_(stack, target, attacker);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, LivingEntity entity) {
        if (!player.m_9236_().f_46443_) {
            if (player.m_36335_().m_41519_((Item)this)) {
                return true;
            }
            player.m_36335_().m_41524_((Item)this, 10);
        }
        return super.onLeftClickEntity(stack, player, (Entity)entity);
    }

    public boolean hasPotionEffectTooltip(ItemStack stack) {
        return true;
    }
}

