/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.client.renderer;

import net.magicvt.extravagantdelight.core.registry.effect.EDModEffects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="extravagantdelight", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrunkVisionRenderer {
    private static boolean isDodging = false;
    private static int dodgeTicks = 0;
    private static float dodgeDirection = 0.0f;
    private static long lastGameTime = -1L;
    private static float prevZza = 0.0f;
    private static float prevXxa = 0.0f;

    public static void triggerDodgeTilt() {
        isDodging = true;
        dodgeTicks = 0;
        dodgeDirection = Minecraft.m_91087_().f_91074_.f_108618_.f_108566_ > 0.0f ? 1.0f : -1.0f;
    }

    @SubscribeEvent
    public static void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        if (localPlayer != null) {
            long currentGameTime = mc.f_91073_.m_46467_();
            if (currentGameTime != lastGameTime) {
                prevZza = localPlayer.f_20902_;
                prevXxa = localPlayer.f_20900_;
                lastGameTime = currentGameTime;
            }
            if (isDodging) {
                if (++dodgeTicks > 10) {
                    isDodging = false;
                } else {
                    float progress = (float)dodgeTicks / 10.0f;
                    float tiltAngle = (float)Math.sin((double)progress * Math.PI) * 15.0f * dodgeDirection;
                    event.setRoll(event.getRoll() + tiltAngle);
                }
            }
            if (localPlayer.m_21023_((MobEffect)EDModEffects.DRUNK_VISION.get())) {
                MobEffectInstance effect = localPlayer.m_21124_((MobEffect)EDModEffects.DRUNK_VISION.get());
                float duration = effect.m_19557_();
                float durationFactor = Math.min(1.0f, duration / 100.0f);
                float intensity = (float)Math.sin((double)durationFactor * Math.PI) * 0.3f;
                intensity = Math.min(0.5f, intensity);
                float time = (float)mc.f_91073_.m_46467_() + mc.m_91296_();
                float moveSpeed = Math.abs(localPlayer.f_20902_ - prevZza) + Math.abs(localPlayer.f_20900_ - prevXxa);
                float bounceIntensity = intensity * (1.0f + moveSpeed * 5.0f);
                float yawWobble = (float)Math.sin(time * 0.8f) * bounceIntensity * 2.0f;
                float pitchWobble = (float)Math.cos(time * 0.6f) * bounceIntensity * 1.5f;
                event.setYaw(event.getYaw() + yawWobble);
                event.setPitch(event.getPitch() + pitchWobble);
            }
        }
    }

    @SubscribeEvent
    public static void onFovSetup(ViewportEvent.ComputeFov event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        if (localPlayer != null && localPlayer.m_21023_((MobEffect)EDModEffects.DRUNK_VISION.get())) {
            MobEffectInstance effect = localPlayer.m_21124_((MobEffect)EDModEffects.DRUNK_VISION.get());
            float duration = effect.m_19557_();
            float durationFactor = Math.min(1.0f, duration / 100.0f);
            float intensity = (float)Math.sin((double)durationFactor * Math.PI) * 0.3f;
            intensity = Math.min(0.5f, intensity);
            float time = (float)mc.f_91073_.m_46467_() + mc.m_91296_();
            float fovModifier = 1.0f + (float)Math.sin(time * 0.4f) * intensity * 0.07f;
            event.setFOV(event.getFOV() * (double)fovModifier);
        }
    }
}

