/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.magicvt.extravagantdelight.core.registry.block.entity.StompingVatBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StompingVatBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty HAS_HOPPER = BooleanProperty.m_61465_((String)"has_hopper");
    private static final VoxelShape INSIDE = StompingVatBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape RIM_NORTH = StompingVatBlock.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape RIM_SOUTH = StompingVatBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)1.0);
    private static final VoxelShape RIM_EAST = StompingVatBlock.m_49796_((double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0);
    private static final VoxelShape RIM_WEST = StompingVatBlock.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)11.0, (double)15.0);
    private static final VoxelShape SHAPE = Stream.of(INSIDE, RIM_NORTH, RIM_SOUTH, RIM_EAST, RIM_WEST).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public StompingVatBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)HAS_HOPPER, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HAS_HOPPER});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)HAS_HOPPER, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (world.f_46443_) {
            return heldItem.m_41619_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pos);
        if (be instanceof StompingVatBlockEntity) {
            StompingVatBlockEntity vat = (StompingVatBlockEntity)be;
            if (heldItem.m_41619_()) {
                ItemStack extracted = vat.extractItem(player);
                if (!extracted.m_41619_()) {
                    world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            if (vat.addItem(heldItem)) {
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        super.m_7892_(state, level, pos, entity);
        if (!level.f_46443_ && ((Boolean)state.m_61143_((Property)HAS_HOPPER)).booleanValue() && entity instanceof Player) {
            Player player = (Player)entity;
            double insideY = (double)pos.m_123342_() + 0.6;
            if (entity.m_20186_() < insideY) {
                player.m_6469_(level.m_269111_().m_269264_(), 0.5f);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new StompingVatBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : (lvl, pos, st, be) -> {
            if (be instanceof StompingVatBlockEntity) {
                StompingVatBlockEntity vat = (StompingVatBlockEntity)be;
                vat.tickServer();
                boolean hasHopper = lvl.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50332_);
                if ((Boolean)st.m_61143_((Property)HAS_HOPPER) != hasHopper) {
                    lvl.m_7731_(pos, (BlockState)st.m_61124_((Property)HAS_HOPPER, (Comparable)Boolean.valueOf(hasHopper)), 3);
                }
            }
        };
    }
}

