/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.custom_blocks;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.common.tag.ForgeTags;

public class EDCakeBlock
extends CakeBlock {
    private final Supplier<Item> slice;

    public EDCakeBlock(BlockBehaviour.Properties prop, Supplier<Item> slice) {
        super(prop);
        this.slice = slice;
    }

    public static void addEatEffect(ItemStack pFood, Level pLevel, Player p) {
        Item item = pFood.m_41720_();
        if (item.m_41472_() && pFood.getFoodProperties((LivingEntity)p) != null) {
            for (Pair pair : Objects.requireNonNull(pFood.getFoodProperties((LivingEntity)p)).m_38749_()) {
                if (pLevel.f_46443_ || pair.getFirst() == null || !(pLevel.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                p.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    public Item getSlice() {
        return this.slice.get();
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack itemstack = player.m_21120_(hand);
        if (level.m_5776_()) {
            if (itemstack.m_204117_(ForgeTags.TOOLS_KNIVES)) {
                return this.cutSlice(level, pos, state, player);
            }
            if (this.eatSlice(level, pos, state, player).m_19077_()) {
                return InteractionResult.SUCCESS;
            }
            if (itemstack.m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        if (itemstack.m_204117_(ForgeTags.TOOLS_KNIVES)) {
            return this.cutSlice(level, pos, state, player);
        }
        return this.eatSlice(level, pos, state, player);
    }

    public InteractionResult eatSlice(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.m_36391_(false)) {
            return InteractionResult.PASS;
        }
        player.m_36220_(Stats.f_12942_);
        Item slice = this.getSlice();
        ItemStack sliceStack = slice.m_7968_();
        player.m_36324_().eat(slice, sliceStack, (LivingEntity)player);
        EDCakeBlock.addEatEffect(sliceStack, level, player);
        level.m_142346_((Entity)player, GameEvent.f_157806_, pos);
        int bites = (Integer)state.m_61143_((Property)f_51180_);
        if (bites < 6) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
            level.m_142346_((Entity)player, GameEvent.f_157794_, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResult cutSlice(Level level, BlockPos pos, BlockState state, Player player) {
        int bites = (Integer)state.m_61143_((Property)f_51180_);
        if (bites < 6) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_51180_, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            level.m_7471_(pos, false);
        }
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)this.getSlice().m_7968_());
        level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.PLAYERS, 0.8f, 0.8f);
        return InteractionResult.SUCCESS;
    }
}

