/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.grapefruit;

import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.magicvt.extravagantdelight.core.registry.block.grapefruit.FlourishingGrapefruitVineBlock;
import net.magicvt.extravagantdelight.core.registry.entity.GrapefruitEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClusterGrapefruitVineBlock
extends Block {
    public static final DirectionProperty FACING = DirectionProperty.m_156003_((String)"facing");

    public ClusterGrapefruitVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
            case Direction.SOUTH -> Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.EAST -> Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            case Direction.WEST -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
            case Direction.UP -> Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
            default -> Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            this.harvest((ServerLevel)level, pos, state);
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (!level.m_5776_() && projectile instanceof AbstractArrow) {
            this.harvest((ServerLevel)level, hit.m_82425_(), state);
        }
        super.m_5581_(level, state, hit, projectile);
    }

    private void harvest(ServerLevel level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        for (int i = 0; i < 3; ++i) {
            double velocityY;
            double velocityZ;
            double velocityX;
            double spawnX = (double)pos.m_123341_() + 0.5;
            double spawnY = (double)pos.m_123342_() + 0.3;
            double spawnZ = (double)pos.m_123343_() + 0.5;
            if (facing == Direction.UP) {
                velocityX = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                velocityZ = (level.f_46441_.m_188500_() - 0.5) * 0.1;
                velocityY = -0.15 - level.f_46441_.m_188500_() * 0.1;
            } else {
                Direction outDir = facing.m_122424_();
                double base = 0.15;
                double side = (level.f_46441_.m_188500_() - 0.5) * 0.15;
                switch (outDir) {
                    case NORTH: {
                        velocityX = side;
                        velocityZ = -base;
                        break;
                    }
                    case SOUTH: {
                        velocityX = side;
                        velocityZ = base;
                        break;
                    }
                    case EAST: {
                        velocityX = base;
                        velocityZ = side;
                        break;
                    }
                    case WEST: {
                        velocityX = -base;
                        velocityZ = side;
                        break;
                    }
                    default: {
                        velocityX = 0.0;
                        velocityZ = 0.0;
                    }
                }
                velocityY = 0.25 + level.f_46441_.m_188500_() * 0.15;
            }
            GrapefruitEntity grapefruit = GrapefruitEntity.create((Level)level, spawnX, spawnY, spawnZ);
            if (grapefruit == null) continue;
            grapefruit.m_20334_(velocityX, velocityY, velocityZ);
            level.m_7967_((Entity)grapefruit);
        }
        level.m_5594_(null, pos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_46597_(pos, (BlockState)((Block)ModBlocks.FLOURISHING_GRAPEFRUIT_VINE.get()).m_49966_().m_61124_((Property)FlourishingGrapefruitVineBlock.FACING, (Comparable)facing));
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockPos leafPos = pos.m_121945_(facing);
        if (!world.m_8055_(leafPos).m_60713_((Block)ModBlocks.GRAPEFRUIT_LEAVES.get())) {
            return false;
        }
        for (Direction dir : Direction.values()) {
            BlockPos checkPos;
            if (dir == facing || world.m_8055_(checkPos = pos.m_121945_(dir)).m_60795_()) continue;
            return true;
        }
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (clickedFace == Direction.UP) {
            return null;
        }
        if (level.m_8055_(pos).m_60713_((Block)ModBlocks.GRAPEFRUIT_LEAVES.get())) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)clickedFace);
        }
        return null;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        Direction facing;
        BlockPos leafPos;
        if (!world.f_46443_ && fromPos.equals((Object)(leafPos = pos.m_121945_(facing = (Direction)state.m_61143_((Property)FACING)))) && !world.m_8055_(leafPos).m_60713_((Block)ModBlocks.GRAPEFRUIT_LEAVES.get())) {
            world.m_46961_(pos, true);
        }
    }
}

