/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.block.grapefruit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.magicvt.extravagantdelight.core.registry.block.grapefruit.GrapefruitVineBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class YoungGrapefruitTreeBlock
extends Block
implements BonemealableBlock {
    public YoungGrapefruitTreeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (random.m_188503_(10) == 0) {
            this.growTree(world, pos, random);
        }
    }

    private void growTree(ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos vinePos;
        Direction dir;
        BlockPos leafPos;
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        List<BlockPos> basePositions = List.of(pos, pos.m_122029_(), pos.m_122019_(), pos.m_122019_().m_122029_());
        for (BlockPos basePos : basePositions) {
            world.m_7731_(basePos, ((Block)ModBlocks.GRAPEFRUIT_WOOD.get()).m_49966_(), 3);
        }
        int trunkHeight = 6 + random.m_188503_(3);
        BlockPos currentPos = pos.m_7494_();
        for (int y = 0; y < trunkHeight; ++y) {
            int dx;
            world.m_7731_(currentPos, ((Block)ModBlocks.GRAPEFRUIT_LOG.get()).m_49966_(), 3);
            if (y > 2 && random.m_188501_() < 0.25f) {
                this.generateBranch(world, currentPos, random);
            }
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, dz);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, 0);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(0, 1, dz);
                continue;
            }
            currentPos = currentPos.m_7494_();
        }
        BlockPos canopyStart = currentPos.m_7949_();
        int crownHeight = 3 + random.m_188503_(2);
        for (int y = 0; y < crownHeight - 1; ++y) {
            int dx;
            world.m_7731_(currentPos, ((Block)ModBlocks.GRAPEFRUIT_LOG.get()).m_49966_(), 3);
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, dz);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                dx = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(dx, 1, 0);
                continue;
            }
            if (random.m_188501_() < 0.15f) {
                int dz = random.m_188499_() ? 1 : -1;
                currentPos = currentPos.m_7918_(0, 1, dz);
                continue;
            }
            currentPos = currentPos.m_7494_();
        }
        ArrayList<BlockPos> leafPositions = new ArrayList<BlockPos>();
        this.generateMinimalCanopy(world, canopyStart.m_6630_(crownHeight - 1), leafPositions);
        for (int y = 0; y < crownHeight; ++y) {
            int radiusZ;
            int radiusX;
            if (y == 0) {
                radiusX = 5;
                radiusZ = 3;
            } else if (y >= crownHeight - 2) {
                radiusX = 4;
                radiusZ = 3;
            } else {
                radiusX = 7 + random.m_188503_(4);
                radiusZ = 4 + random.m_188503_(4);
            }
            radiusZ -= y / 3;
            for (int x = -(radiusX -= y / 2); x <= radiusX; ++x) {
                for (int z = -radiusZ; z <= radiusZ; ++z) {
                    double distance = Math.sqrt(Math.pow((double)x * 1.0 / (double)radiusX, 2.0) + Math.pow((double)z * 1.0 / (double)radiusZ, 2.0) + random.m_188500_() * 0.07);
                    float chance = 1.0f;
                    if (y > 0) {
                        float f = chance = y < crownHeight - 2 ? 0.9f : 0.85f;
                    }
                    if (!(distance <= 1.0) || !(random.m_188501_() < chance)) continue;
                    BlockPos leafPos2 = canopyStart.m_7918_(x, y, z);
                    BlockState belowState = world.m_8055_(leafPos2.m_7495_());
                    if (!world.m_8055_(leafPos2).m_60795_() || y != 0 && !belowState.m_60713_((Block)ModBlocks.GRAPEFRUIT_LOG.get()) && !belowState.m_60713_((Block)ModBlocks.GRAPEFRUIT_LEAVES.get())) continue;
                    world.m_7731_(leafPos2, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                    leafPositions.add(leafPos2);
                }
            }
        }
        if (leafPositions.size() <= 10) {
            this.extendMinimalCanopy(world, canopyStart.m_6630_(crownHeight - 1), leafPositions);
        }
        ArrayList<BlockPos> eligibleLeafPositions = new ArrayList<BlockPos>();
        HashMap availableDirectionsMap = new HashMap();
        for (BlockPos leafPos3 : leafPositions) {
            ArrayList<Direction> availableDirections = new ArrayList<Direction>();
            for (Direction dir2 : Direction.Plane.HORIZONTAL) {
                BlockPos vinePos2 = leafPos3.m_121945_(dir2);
                if (!world.m_8055_(vinePos2).m_60795_()) continue;
                availableDirections.add(dir2);
            }
            BlockPos downPos = leafPos3.m_7495_();
            if (world.m_8055_(downPos).m_60795_()) {
                availableDirections.add(Direction.DOWN);
            }
            if (availableDirections.isEmpty()) continue;
            eligibleLeafPositions.add(leafPos3);
            availableDirectionsMap.put(leafPos3, availableDirections);
        }
        int mandatoryVines = Math.min(3, eligibleLeafPositions.size());
        ArrayList<BlockPos> usedLeaves = new ArrayList<BlockPos>();
        for (int i = 0; i < mandatoryVines && !eligibleLeafPositions.isEmpty(); ++i) {
            int index = random.m_188503_(eligibleLeafPositions.size());
            leafPos = (BlockPos)eligibleLeafPositions.get(index);
            eligibleLeafPositions.remove(index);
            usedLeaves.add(leafPos);
            List directions = (List)availableDirectionsMap.get(leafPos);
            dir = (Direction)directions.get(random.m_188503_(directions.size()));
            vinePos = leafPos.m_121945_(dir);
            if (!world.m_8055_(vinePos).m_60795_()) continue;
            world.m_7731_(vinePos, (BlockState)((Block)ModBlocks.GRAPEFRUIT_VINE.get()).m_49966_().m_61124_((Property)GrapefruitVineBlock.FACING, (Comparable)dir.m_122424_()), 3);
        }
        int remainingVines = 5 + random.m_188503_(5);
        Collections.shuffle(eligibleLeafPositions, new Random(random.m_188505_()));
        for (int i = 0; i < remainingVines && i < eligibleLeafPositions.size(); ++i) {
            List directions;
            leafPos = (BlockPos)eligibleLeafPositions.get(i);
            vinePos = leafPos.m_121945_(dir = (Direction)(directions = (List)availableDirectionsMap.get(leafPos)).get(random.m_188503_(directions.size())));
            if (!world.m_8055_(vinePos).m_60795_()) continue;
            world.m_7731_(vinePos, (BlockState)((Block)ModBlocks.GRAPEFRUIT_VINE.get()).m_49966_().m_61124_((Property)GrapefruitVineBlock.FACING, (Comparable)dir.m_122424_()), 3);
        }
    }

    private void generateBranch(ServerLevel world, BlockPos trunkPos, RandomSource random) {
        Direction dir = null;
        BlockPos.MutableBlockPos testPos = trunkPos.m_122032_();
        for (Direction testDir : Direction.Plane.HORIZONTAL) {
            testPos.m_122190_((Vec3i)trunkPos);
            testPos.m_122173_(testDir);
            if (!world.m_8055_((BlockPos)testPos).m_60795_()) continue;
            dir = testDir;
            break;
        }
        if (dir == null) {
            return;
        }
        BlockPos.MutableBlockPos branchPos = trunkPos.m_122032_();
        int length = 2 + random.m_188503_(2);
        for (int i = 0; i < length; ++i) {
            branchPos.m_122173_(dir);
            if (!world.m_8055_((BlockPos)branchPos).m_60795_()) break;
            world.m_7731_((BlockPos)branchPos, (BlockState)((Block)ModBlocks.GRAPEFRUIT_LOG.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)dir.m_122434_()), 3);
        }
        BlockPos branchEnd = branchPos.m_7949_();
        this.generateMiniCrown(world, branchEnd, random);
    }

    private void generateMiniCrown(ServerLevel world, BlockPos center, RandomSource random) {
        int crownHeight = 2 + random.m_188503_(2);
        for (int y = 0; y < crownHeight; ++y) {
            int radius = y == 0 ? 2 : 1;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos leafPos;
                    double distance = Math.sqrt(x * x + z * z) + random.m_188500_() * 0.3;
                    if (!(distance <= (double)radius + 0.5) || !world.m_8055_(leafPos = center.m_7918_(x, y, z)).m_60795_()) continue;
                    world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                }
            }
        }
    }

    private void generateMinimalCanopy(ServerLevel world, BlockPos center, List<BlockPos> leafPositions) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = 0; y < 1; ++y) {
                    BlockPos leafPos = center.m_7918_(x, y, z);
                    if (!world.m_8055_(leafPos).m_60795_()) continue;
                    world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                    leafPositions.add(leafPos);
                }
            }
        }
    }

    private void extendMinimalCanopy(ServerLevel world, BlockPos center, List<BlockPos> leafPositions) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = 0; y < 2; ++y) {
                    BlockPos leafPos;
                    double distance = Math.sqrt(x * x + z * z);
                    if (distance > 3.5 || !world.m_8055_(leafPos = center.m_7918_(x, y, z)).m_60795_()) continue;
                    world.m_7731_(leafPos, ((Block)ModBlocks.GRAPEFRUIT_LEAVES.get()).m_49966_(), 3);
                    leafPositions.add(leafPos);
                }
            }
        }
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean b) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.growTree(world, pos, random);
    }
}

