/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.effect;

import net.magicvt.extravagantdelight.core.registry.block.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class StickyHoldEffect
extends MobEffect {
    public StickyHoldEffect() {
        super(MobEffectCategory.BENEFICIAL, 9127187);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 movement = player.m_20184_();
            if (!player.m_20096_() && this.isAdjacentToWall(player)) {
                double newX = movement.f_82479_ * 0.1;
                double newZ = movement.f_82481_ * 0.1;
                double newY = movement.f_82480_;
                if (newY < 0.0) {
                    double maxFallSpeed = -0.05 + (double)amplifier * 0.01;
                    newY = Math.max(newY, maxFallSpeed);
                    if (player.f_19797_ % 5 == 0) {
                        player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11968_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        this.createOrangeParticles(player);
                    }
                }
                player.m_20334_(newX, newY, newZ);
                player.f_19789_ = 0.0f;
            }
        }
    }

    private void createOrangeParticles(Player player) {
        Level level = player.m_9236_();
        Direction wallDirection = this.getWallDirection(player);
        if (wallDirection != null) {
            Vec3 playerPos = player.m_20182_();
            Vec3 offset = Vec3.m_82528_((Vec3i)wallDirection.m_122436_()).m_82490_(0.3);
            Vec3 particlePos = playerPos.m_82549_(offset);
            BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.f_123794_, ((Block)ModBlocks.QUINCE_JAM_BLOCK.get()).m_49966_());
            for (int i = 0; i < 5; ++i) {
                double offsetX = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                double offsetY = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                double offsetZ = (level.f_46441_.m_188500_() - 0.5) * 0.3;
                level.m_7106_((ParticleOptions)particleData, particlePos.f_82479_ + offsetX, particlePos.f_82480_ + offsetY, particlePos.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean isAdjacentToWall(Player player) {
        Level level = player.m_9236_();
        BlockPos pos = player.m_20183_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            double distanceToWall;
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState blockState = level.m_8055_(adjacentPos);
            if (!blockState.m_60804_((BlockGetter)level, adjacentPos) || !((distanceToWall = this.getDistanceToWall(player, direction)) <= 0.5)) continue;
            return true;
        }
        return false;
    }

    private double getDistanceToWall(Player player, Direction direction) {
        switch (direction) {
            case NORTH: {
                return player.m_20189_() - Math.floor(player.m_20189_());
            }
            case SOUTH: {
                return Math.ceil(player.m_20189_()) - player.m_20189_();
            }
            case WEST: {
                return player.m_20185_() - Math.floor(player.m_20185_());
            }
            case EAST: {
                return Math.ceil(player.m_20185_()) - player.m_20185_();
            }
        }
        return 1.0;
    }

    private Direction getWallDirection(Player player) {
        Level level = player.m_9236_();
        BlockPos pos = player.m_20183_();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            double distanceToWall;
            BlockPos adjacentPos = pos.m_121945_(direction);
            BlockState blockState = level.m_8055_(adjacentPos);
            if (!blockState.m_60804_((BlockGetter)level, adjacentPos) || !((distanceToWall = this.getDistanceToWall(player, direction)) <= 0.5)) continue;
            return direction;
        }
        return null;
    }
}

