/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.event;

import java.util.List;
import net.magicvt.extravagantdelight.core.registry.effect.EDModEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="extravagantdelight")
public class DrunkVisionHandler {
    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_21023_((MobEffect)EDModEffects.DRUNK_VISION.get())) {
            MobEffectInstance effect = player.m_21124_((MobEffect)EDModEffects.DRUNK_VISION.get());
            int amplifier = effect.m_19564_();
            double radius = DrunkVisionHandler.getRadiusForLevel(amplifier);
            if (player.f_19797_ % 10 == 0) {
                DrunkVisionHandler.revealNearbyHostiles(player, radius);
            }
        }
    }

    private static double getRadiusForLevel(int amplifier) {
        return 6.0 + (double)amplifier * 2.0;
    }

    private static void revealNearbyHostiles(Player player, double radius) {
        Level level = player.m_9236_();
        AABB searchArea = new AABB(player.m_20185_() - radius, player.m_20186_() - radius, player.m_20189_() - radius, player.m_20185_() + radius, player.m_20186_() + radius, player.m_20189_() + radius);
        List hostiles = level.m_6443_(LivingEntity.class, searchArea, entity -> entity != player && entity.m_6095_().m_20674_() == MobCategory.MONSTER && entity.m_6084_());
        for (LivingEntity hostile : hostiles) {
            hostile.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 20, 0, false, false, true));
        }
    }
}

