/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.core.registry.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.magicvt.extravagantdelight.core.registry.effect.EDModEffects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="extravagantdelight")
public class MangoBreezeHandler {
    private static final Map<UUID, Integer> glideTicksMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, Boolean> wasOnGroundMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Double> lastYPosMap = new HashMap<UUID, Double>();
    private static final Map<UUID, Double> peakYMap = new HashMap<UUID, Double>();
    private static final Map<UUID, Boolean> isGlidingMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Boolean> wasAscendingMap = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> jumpCooldownMap = new HashMap<UUID, Integer>();
    private static final int LEVEL_1_DURATION = 60;
    private static final int LEVEL_2_DURATION = 200;
    private static final int LEVEL_3_DURATION = 300;
    private static final int JUMP_COOLDOWN = 10;

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        UUID playerUUID = player.m_20148_();
        if (!wasOnGroundMap.containsKey(playerUUID)) {
            wasOnGroundMap.put(playerUUID, true);
            lastYPosMap.put(playerUUID, player.m_20186_());
            isGlidingMap.put(playerUUID, false);
            wasAscendingMap.put(playerUUID, false);
            jumpCooldownMap.put(playerUUID, 0);
        }
        boolean hasEffect = player.m_21023_((MobEffect)EDModEffects.MANGO_BREEZE.get());
        boolean wasOnGround = wasOnGroundMap.get(playerUUID);
        double lastYPos = lastYPosMap.get(playerUUID);
        boolean isGliding = isGlidingMap.get(playerUUID);
        boolean wasAscending = wasAscendingMap.get(playerUUID);
        int jumpCooldown = jumpCooldownMap.get(playerUUID);
        double deltaY = player.m_20186_() - lastYPos;
        boolean isAscending = deltaY > 0.01;
        wasOnGroundMap.put(playerUUID, Math.abs(deltaY) < 0.1 && player.m_20184_().f_82480_ <= 0.0);
        lastYPosMap.put(playerUUID, player.m_20186_());
        wasAscendingMap.put(playerUUID, isAscending);
        if (jumpCooldown > 0) {
            jumpCooldownMap.put(playerUUID, jumpCooldown - 1);
        }
        if (wasAscending && !isAscending && hasEffect && !isGliding && jumpCooldown == 0) {
            MobEffectInstance effect = player.m_21124_((MobEffect)EDModEffects.MANGO_BREEZE.get());
            int amplifier = effect.m_19564_();
            glideTicksMap.put(playerUUID, switch (amplifier) {
                case 0 -> 60;
                case 1 -> 200;
                default -> 300;
            });
            isGlidingMap.put(playerUUID, true);
            peakYMap.put(playerUUID, player.m_20186_());
            jumpCooldownMap.put(playerUUID, 10);
        }
        if (glideTicksMap.containsKey(playerUUID)) {
            int ticksLeft = glideTicksMap.get(playerUUID);
            if (ticksLeft > 0) {
                double rightZ;
                double moveZ;
                float forward = player.f_20902_;
                float strafe = player.f_20900_;
                float yaw = player.m_146908_();
                double yawRad = Math.toRadians(yaw);
                double forwardX = -Math.sin(yawRad);
                double forwardZ = Math.cos(yawRad);
                double rightX = Math.cos(yawRad);
                double moveX = forwardX * (double)forward + rightX * (double)strafe;
                double length = Math.sqrt(moveX * moveX + (moveZ = forwardZ * (double)forward + (rightZ = Math.sin(yawRad)) * (double)strafe) * moveZ);
                if (length > 0.0) {
                    moveX /= length;
                    moveZ /= length;
                }
                float speed = 0.2f;
                player.m_20334_(moveX * (double)speed, 0.0, moveZ * (double)speed);
                double peakY = peakYMap.get(playerUUID);
                if (Math.abs(player.m_20186_() - peakY) > 0.1) {
                    player.m_6034_(player.m_20185_(), peakY, player.m_20189_());
                }
                if (ticksLeft % 2 == 0) {
                    for (int i = 0; i < 5; ++i) {
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 0.5, player.m_20186_() - 0.2, player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 0.5, 0.0, 0.0, 0.0);
                    }
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), 1.0, player.m_20189_(), 0.0, 0.0, 0.0);
                }
                glideTicksMap.put(playerUUID, ticksLeft - 1);
            } else {
                glideTicksMap.remove(playerUUID);
                peakYMap.remove(playerUUID);
                isGlidingMap.put(playerUUID, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerUUID = event.getEntity().m_20148_();
        glideTicksMap.remove(playerUUID);
        wasOnGroundMap.remove(playerUUID);
        lastYPosMap.remove(playerUUID);
        peakYMap.remove(playerUUID);
        isGlidingMap.remove(playerUUID);
        wasAscendingMap.remove(playerUUID);
        jumpCooldownMap.remove(playerUUID);
    }
}

