/*
 * Decompiled with CFR 0.152.
 */
package net.magicvt.extravagantdelight.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.magicvt.extravagantdelight.recipe.ModRecipes;
import net.magicvt.extravagantdelight.recipe.StompingVatInventory;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class StompingVatRecipe
implements Recipe<StompingVatInventory> {
    private final ResourceLocation id;
    private final String group;
    private final List<Ingredient> ingredients;
    private final ItemStack result;
    private final ResourceLocation particleBlock;
    private final Ingredient requiredItem;

    public StompingVatRecipe(ResourceLocation id, String group, List<Ingredient> ingredients, ItemStack result, ResourceLocation particleBlock, Ingredient requiredItem) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
        this.particleBlock = particleBlock;
        this.requiredItem = requiredItem;
    }

    public boolean matches(StompingVatInventory inventory, Level level) {
        ArrayList<ItemStack> inventoryItems = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            inventoryItems.add(stack);
        }
        if (inventoryItems.size() != this.ingredients.size()) {
            return false;
        }
        for (Ingredient ingredient : this.ingredients) {
            boolean found = false;
            for (int i = 0; i < inventoryItems.size(); ++i) {
                if (!ingredient.test((ItemStack)inventoryItems.get(i))) continue;
                inventoryItems.remove(i);
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble(StompingVatInventory inventory, RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])this.ingredients.toArray(new Ingredient[0]));
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.STOMPING_VAT_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.STOMPING_VAT_TYPE.get();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public ResourceLocation getParticleBlock() {
        return this.particleBlock;
    }

    public Ingredient getRequiredItem() {
        return this.requiredItem;
    }

    public static class Serializer
    implements RecipeSerializer<StompingVatRecipe> {
        public StompingVatRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = json.has("group") ? json.get("group").getAsString() : "";
            JsonArray ingredientsArray = json.getAsJsonArray("ingredients");
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i = 0; i < ingredientsArray.size(); ++i) {
                ingredients.add(Ingredient.m_43917_((JsonElement)ingredientsArray.get(i)));
            }
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject("result"));
            ResourceLocation particleBlock = new ResourceLocation("minecraft", "stone");
            if (json.has("particle_block")) {
                particleBlock = new ResourceLocation(json.get("particle_block").getAsString());
            }
            Ingredient requiredItem = Ingredient.f_43901_;
            if (json.has("requirement_item")) {
                requiredItem = Ingredient.m_43917_((JsonElement)json.getAsJsonObject("requirement_item"));
            }
            return new StompingVatRecipe(recipeId, group, ingredients, result, particleBlock, requiredItem);
        }

        @Nullable
        public StompingVatRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130277_();
            int ingredientCount = buffer.m_130242_();
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>(ingredientCount);
            for (int i = 0; i < ingredientCount; ++i) {
                ingredients.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack result = buffer.m_130267_();
            ResourceLocation particleBlock = buffer.m_130281_();
            Ingredient requiredItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new StompingVatRecipe(recipeId, group, ingredients, result, particleBlock, requiredItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, StompingVatRecipe recipe) {
            buffer.m_130070_(recipe.group);
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.result);
            buffer.m_130085_(recipe.particleBlock);
            recipe.requiredItem.m_43923_(buffer);
        }
    }
}

