/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.event;

import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.EventStepRegistry;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.api.event.step.Condition;
import dev.jsinco.brewery.api.event.step.ConditionalStep;
import dev.jsinco.brewery.api.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.api.event.step.ConsumeStep;
import dev.jsinco.brewery.api.event.step.CustomEventStep;
import dev.jsinco.brewery.api.event.step.SendCommand;
import dev.jsinco.brewery.api.event.step.Teleport;
import dev.jsinco.brewery.api.event.step.WaitStep;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.effect.named.ChickenNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.DrunkMessageNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.DrunkenWalkNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.FeverNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.HallucinationNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.KaboomNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.NauseaNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.PassOutNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.PukeNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.StumbleNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.named.TeleportNamedExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ApplyPotionEffectExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ConditionalStepExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ConditionalWaitStepExecutable;
import dev.jsinco.brewery.bukkit.effect.step.ConsumeStepExecutable;
import dev.jsinco.brewery.bukkit.effect.step.CustomEventExecutable;
import dev.jsinco.brewery.bukkit.effect.step.SendCommandExecutable;
import dev.jsinco.brewery.bukkit.effect.step.TeleportExecutable;
import dev.jsinco.brewery.bukkit.effect.step.WaitStepExecutable;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class DrunkEventExecutor {
    private final Map<UUID, List<List<EventStep>>> onJoinServerExecutions = new HashMap<UUID, List<List<EventStep>>>();
    private final Map<UUID, List<List<EventStep>>> onDeathExecutions = new HashMap<UUID, List<List<EventStep>>>();
    private final Map<UUID, List<List<EventStep>>> onDamageExecutions = new HashMap<UUID, List<List<EventStep>>>();
    private final Map<UUID, Map<String, List<List<EventStep>>>> onJoinedWorldExecutions = new HashMap<UUID, Map<String, List<List<EventStep>>>>();

    public DrunkEventExecutor() {
        EventStepRegistry registry = TheBrewingProject.getInstance().getEventStepRegistry();
        registry.register(NamedDrunkEvent.fromKey("chicken"), ChickenNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("drunken_walk"), DrunkenWalkNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("drunk_message"), DrunkMessageNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("fever"), FeverNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("hallucination"), HallucinationNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("kaboom"), KaboomNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("nausea"), NauseaNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("pass_out"), PassOutNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("puke"), PukeNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("stumble"), StumbleNamedExecutable::new);
        registry.register(NamedDrunkEvent.fromKey("teleport"), TeleportNamedExecutable::new);
        registry.register(ApplyPotionEffect.class, stepProperty -> new ApplyPotionEffectExecutable(stepProperty.potionEffectName(), stepProperty.amplifierBounds(), stepProperty.durationBounds()));
        registry.register(ConditionalWaitStep.class, stepProperty -> new ConditionalWaitStepExecutable(stepProperty.getCondition()));
        registry.register(ConditionalStep.class, stepProperty -> new ConditionalStepExecutable(stepProperty.condition()));
        registry.register(ConsumeStep.class, stepProperty -> new ConsumeStepExecutable(stepProperty.modifiers()));
        registry.register(SendCommand.class, stepProperty -> new SendCommandExecutable(stepProperty.command(), stepProperty.senderType()));
        registry.register(Teleport.class, stepProperty -> new TeleportExecutable(stepProperty.location()));
        registry.register(WaitStep.class, stepProperty -> new WaitStepExecutable(stepProperty.durationTicks()));
        CustomEventRegistry eventRegistry = TheBrewingProject.getInstance().getCustomDrunkEventRegistry();
        registry.register(CustomEventStep.class, stepProperty -> new CustomEventExecutable(eventRegistry.getCustomEvent(stepProperty.customEventKey()).getSteps()));
    }

    public void doDrunkEvent(UUID playerUuid, DrunkEvent event) {
        if (event instanceof NamedDrunkEvent) {
            NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)event;
            this.doDrunkEvents(playerUuid, List.of(new EventStep.Builder().addProperty(namedDrunkEvent).build()));
        } else if (event instanceof CustomEvent.Keyed) {
            CustomEvent.Keyed customEvent = (CustomEvent.Keyed)event;
            this.doDrunkEvents(playerUuid, customEvent.getSteps());
        }
    }

    public void doDrunkEvents(UUID playerUuid, List<? extends EventStep> events) {
        EventStepRegistry registry = TheBrewingProject.getInstance().getEventStepRegistry();
        for (int i = 0; i < events.size(); ++i) {
            EventStep event = events.get(i);
            List<EventPropertyExecutable> properties = event.properties().stream().map(registry::toExecutable).sorted(Comparator.comparing(EventPropertyExecutable::priority, Integer::compareTo)).toList();
            for (EventPropertyExecutable eventPropertyExecutable : properties) {
                if (eventPropertyExecutable.execute(playerUuid, events, i) != EventPropertyExecutable.ExecutionResult.STOP_EXECUTION) continue;
                return;
            }
        }
    }

    public void addConditionalWaitExecution(UUID playerUuid, List<EventStep> events, Condition condition) {
        Condition condition2 = condition;
        Objects.requireNonNull(condition2);
        Condition condition3 = condition2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Condition.Died.class, Condition.HasPermission.class, Condition.JoinedServer.class, Condition.JoinedWorld.class, Condition.TookDamage.class}, (Object)condition3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Condition.Died died = (Condition.Died)condition3;
                this.onDeathExecutions.computeIfAbsent(playerUuid, ignored -> new ArrayList()).add(events);
                break;
            }
            case 1: {
                Condition.HasPermission hasPermission = (Condition.HasPermission)condition3;
                throw new IllegalStateException("Can not schedule 'has permission' conditions");
            }
            case 2: {
                Condition.JoinedServer joinedServer = (Condition.JoinedServer)condition3;
                if (Bukkit.getPlayer((UUID)playerUuid) != null) {
                    this.doDrunkEvents(playerUuid, events);
                    return;
                }
                this.onJoinServerExecutions.computeIfAbsent(playerUuid, ignored -> new ArrayList()).add(events);
                break;
            }
            case 3: {
                Player player;
                Condition.JoinedWorld joinedWorld = (Condition.JoinedWorld)condition3;
                Player player2 = Bukkit.getPlayer((UUID)playerUuid);
                if (player2 instanceof Player && (player = player2).getWorld().getName().equals(joinedWorld.worldName())) {
                    this.doDrunkEvents(playerUuid, events);
                    return;
                }
                this.onJoinedWorldExecutions.computeIfAbsent(playerUuid, ignored -> new HashMap()).computeIfAbsent(joinedWorld.worldName(), ignored -> new ArrayList()).add(events);
                break;
            }
            case 4: {
                Condition.TookDamage tookDamage = (Condition.TookDamage)condition3;
                this.onDamageExecutions.computeIfAbsent(playerUuid, ignored -> new ArrayList()).add(events);
            }
        }
    }

    public void clear(UUID playerUuid) {
        this.onJoinServerExecutions.remove(playerUuid);
    }

    public void clear() {
        this.onJoinServerExecutions.clear();
        this.onDeathExecutions.clear();
        this.onDamageExecutions.clear();
        this.onJoinedWorldExecutions.clear();
    }

    public void onPlayerJoinServer(UUID playerUuid) {
        this.executeQueue(playerUuid, this.onJoinServerExecutions.remove(playerUuid));
    }

    public void onPlayerJoinWorld(UUID playerUuid, World world) {
        this.executeQueue(playerUuid, (List)this.onJoinedWorldExecutions.computeIfAbsent(playerUuid, ignored -> new HashMap()).remove(world.getName()));
    }

    public void onDamage(UUID playerUuid) {
        this.executeQueue(playerUuid, this.onDamageExecutions.remove(playerUuid));
    }

    public void onDeathExecutions(UUID playerUuid) {
        this.executeQueue(playerUuid, this.onDeathExecutions.remove(playerUuid));
    }

    private void executeQueue(UUID playerUuid, List<List<EventStep>> eventStepListQueue) {
        if (eventStepListQueue == null) {
            return;
        }
        eventStepListQueue.forEach(eventSteps -> this.doDrunkEvents(playerUuid, (List<? extends EventStep>)eventSteps));
    }
}

