/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.event;

import com.destroystokyo.paper.event.player.PlayerLaunchProjectileEvent;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.breweries.InventoryAccessible;
import dev.jsinco.brewery.api.breweries.StructureHolder;
import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.ModifierConsume;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.ScoredIngredient;
import dev.jsinco.brewery.api.structure.SinglePositionStructure;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.breweries.BukkitCauldron;
import dev.jsinco.brewery.bukkit.breweries.BukkitCauldronDataType;
import dev.jsinco.brewery.bukkit.effect.event.DrunkEventExecutor;
import dev.jsinco.brewery.bukkit.event.ListenerUtil;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.configuration.serializers.ConsumableSerializer;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.Database;
import dev.jsinco.brewery.effect.DrunksManagerImpl;
import dev.jsinco.brewery.effect.text.DrunkTextRegistry;
import dev.jsinco.brewery.effect.text.DrunkTextTransformer;
import dev.jsinco.brewery.format.TimeFormat;
import dev.jsinco.brewery.format.TimeFormatter;
import dev.jsinco.brewery.format.TimeModifier;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import dev.jsinco.brewery.structure.PlacedStructureRegistryImpl;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.GameMode;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerEventListener
implements Listener {
    public static final Set<Material> DISALLOWED_INGREDIENT_MATERIALS = Set.of(Material.CLOCK, Material.BUCKET, Material.GLASS_BOTTLE);
    private static final Random RANDOM = new Random();
    private final PlacedStructureRegistryImpl placedStructureRegistry;
    private final BreweryRegistry breweryRegistry;
    private final Database database;
    private final DrunksManagerImpl<?> drunksManager;
    private final DrunkTextRegistry drunkTextRegistry;
    private final RecipeRegistryImpl<ItemStack> recipeRegistry;
    private final DrunkEventExecutor drunkEventExecutor;

    public PlayerEventListener(PlacedStructureRegistryImpl placedStructureRegistry, BreweryRegistry breweryRegistry, Database database, DrunksManagerImpl<?> drunksManager, DrunkTextRegistry drunkTextRegistry, RecipeRegistryImpl<ItemStack> recipeRegistry, DrunkEventExecutor drunkEventExecutor) {
        this.placedStructureRegistry = placedStructureRegistry;
        this.breweryRegistry = breweryRegistry;
        this.database = database;
        this.drunksManager = drunksManager;
        this.drunkTextRegistry = drunkTextRegistry;
        this.recipeRegistry = recipeRegistry;
        this.drunkEventExecutor = drunkEventExecutor;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractStructure(PlayerInteractEvent playerInteractEvent) {
        InventoryAccessible inventoryAccessible;
        if (playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK || playerInteractEvent.getPlayer().isSneaking() || playerInteractEvent.getHand() != EquipmentSlot.HAND) {
            return;
        }
        BreweryLocation location = BukkitAdapter.toBreweryLocation(playerInteractEvent.getClickedBlock().getLocation());
        Optional<StructureHolder<?>> possibleStructureHolder = this.placedStructureRegistry.getHolder(location);
        if (possibleStructureHolder.isEmpty()) {
            return;
        }
        if (!TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationTypes.STRUCTURE).stream().map(structureIntegration -> structureIntegration.hasAccess(playerInteractEvent.getClickedBlock(), playerInteractEvent.getPlayer(), ((StructureHolder)possibleStructureHolder.get()).getStructureType().key())).reduce(true, Boolean::logicalAnd).booleanValue()) {
            MessageUtil.message((Audience)playerInteractEvent.getPlayer(), "tbp." + possibleStructureHolder.get().getStructureType().key().key().toLowerCase() + ".access-denied", new TagResolver[0]);
            return;
        }
        StructureHolder<?> structureHolder = possibleStructureHolder.get();
        if (structureHolder instanceof InventoryAccessible && (inventoryAccessible = (InventoryAccessible)((Object)structureHolder)).open(BukkitAdapter.toBreweryLocation(playerInteractEvent.getClickedBlock()), playerInteractEvent.getPlayer().getUniqueId())) {
            this.breweryRegistry.registerOpened(inventoryAccessible);
        }
        playerInteractEvent.setUseItemInHand(Event.Result.DENY);
        playerInteractEvent.setUseInteractedBlock(Event.Result.DENY);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK || event.useItemInHand() == Event.Result.DENY || !event.hasItem()) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        boolean cauldron = Tag.CAULDRONS.isTagged((Keyed)block.getType());
        if (!TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationTypes.STRUCTURE).stream().map(structureIntegration -> structureIntegration.hasAccess(event.getClickedBlock(), event.getPlayer(), cauldron ? BreweryKey.parse("cauldron") : BreweryKey.parse("sealing_table"))).reduce(true, Boolean::logicalAnd).booleanValue()) {
            if (cauldron) {
                if (this.breweryRegistry.getActiveSinglePositionStructure(BukkitAdapter.toBreweryLocation(block)).filter(BukkitCauldron.class::isInstance).map(BukkitCauldron.class::cast).isPresent()) {
                    MessageUtil.message((Audience)event.getPlayer(), "tbp.cauldron.access-denied", new TagResolver[0]);
                    event.setCancelled(true);
                }
            }
            return;
        }
        if (cauldron) {
            this.handleCauldron(event, block);
        }
        PlayerInventory inventory = event.getPlayer().getInventory();
        ItemStack offHand = inventory.getItemInOffHand();
        if (block.getType() == Material.CRAFTING_TABLE && offHand.getType() == Material.PAPER && event.getPlayer().isSneaking() && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            ItemStack mainHand = inventory.getItemInMainHand();
            ItemStack sealed = BrewAdapter.fromItem(mainHand).map(brew -> BrewAdapter.toItem(brew, new Brew.State.Seal(offHand.hasData((DataComponentType)DataComponentTypes.CUSTOM_NAME) ? (String)MiniMessage.miniMessage().serialize((Component)offHand.getData(DataComponentTypes.CUSTOM_NAME)) : null))).orElse(mainHand);
            inventory.setItemInMainHand(sealed);
            event.setUseItemInHand(Event.Result.DENY);
            this.decreaseItem(offHand, event.getPlayer());
            inventory.setItemInOffHand(offHand);
        }
    }

    private ItemStack decreaseItem(ItemStack itemStack, Player player) {
        if (player.getGameMode() == GameMode.CREATIVE && !Config.config().consumeItemsInCreative()) {
            return itemStack;
        }
        if (itemStack.getType() == Material.POTION) {
            return new ItemStack(Material.GLASS_BOTTLE);
        }
        if (itemStack.getType() == Material.MILK_BUCKET) {
            return new ItemStack(Material.BUCKET);
        }
        itemStack.setAmount(itemStack.getAmount() - 1);
        return itemStack;
    }

    private void handleCauldron(PlayerInteractEvent event, @NotNull Block block) {
        boolean addedIngredient;
        Optional<BukkitCauldron> cauldronOptional = this.breweryRegistry.getActiveSinglePositionStructure(BukkitAdapter.toBreweryLocation(block)).filter(BukkitCauldron.class::isInstance).map(BukkitCauldron.class::cast);
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        if (this.isIngredient(itemStack) && (addedIngredient = this.handleIngredientAddition(itemStack, block, cauldronOptional.orElse(null), event.getPlayer(), event.getHand()))) {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
        }
        if (itemStack.getType() == Material.GLASS_BOTTLE) {
            cauldronOptional.map(BukkitCauldron::extractBrew).ifPresent(brewItemStack -> {
                this.updateHeldItem(this.decreaseItem(itemStack, event.getPlayer()), event.getPlayer(), event.getHand());
                event.getPlayer().getWorld().dropItem(event.getPlayer().getLocation(), brewItemStack);
                if (BukkitCauldron.decrementLevel(block)) {
                    ListenerUtil.removeActiveSinglePositionStructure((SinglePositionStructure)cauldronOptional.get(), this.breweryRegistry, this.database);
                }
            });
        }
        cauldronOptional.filter(cauldron -> itemStack.getType() == Material.CLOCK).filter(cauldron -> event.getPlayer().hasPermission("brewery.cauldron.time")).ifPresent(cauldron -> event.getPlayer().sendMessage((Component)Component.translatable((String)"tbp.cauldron.clock-message", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)Placeholder.parsed((String)"time", (String)TimeFormatter.format(cauldron.getTime(), TimeFormat.CLOCK_MECHANIC, TimeModifier.COOKING)))})));
        cauldronOptional.ifPresent(ignored -> {
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setUseItemInHand(Event.Result.DENY);
        });
    }

    private boolean handleIngredientAddition(ItemStack itemStack, Block block, @Nullable BukkitCauldron cauldron, Player player, @Nullable EquipmentSlot hand) {
        boolean addedIngredient;
        if (block.getType() == Material.CAULDRON && itemStack.getType() != Material.POTION) {
            return false;
        }
        if (cauldron == null) {
            cauldron = this.initCauldron(block);
        }
        if (addedIngredient = cauldron.addIngredient(itemStack, player)) {
            this.updateHeldItem(this.decreaseItem(itemStack, player), player, hand);
            try {
                this.database.updateValue(BukkitCauldronDataType.INSTANCE, cauldron);
            }
            catch (PersistenceException e) {
                Logger.logErr(e);
            }
        }
        return addedIngredient;
    }

    private void updateHeldItem(ItemStack item, Player player, EquipmentSlot equipmentSlot) {
        if (equipmentSlot == EquipmentSlot.HAND) {
            player.getInventory().setItemInMainHand(item);
        } else if (equipmentSlot == EquipmentSlot.OFF_HAND) {
            player.getInventory().setItemInOffHand(item);
        } else {
            throw new IllegalArgumentException("Only main hand and offhand equipment slots are allowed: " + String.valueOf(equipmentSlot));
        }
    }

    private BukkitCauldron initCauldron(Block block) {
        BukkitCauldron newCauldron = new BukkitCauldron(BukkitAdapter.toBreweryLocation(block), BukkitCauldron.isHeatSource(block.getRelative(BlockFace.DOWN)));
        try {
            this.database.insertValue(BukkitCauldronDataType.INSTANCE, newCauldron);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
        this.breweryRegistry.addActiveSinglePositionStructure(newCauldron);
        return newCauldron;
    }

    private boolean isIngredient(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Material type = itemStack.getType();
        if (DISALLOWED_INGREDIENT_MATERIALS.contains(type)) {
            return false;
        }
        if (Config.config().allowUnregisteredIngredients()) {
            return true;
        }
        Ingredient ingredient = BukkitIngredientManager.INSTANCE.getIngredient(itemStack);
        if (ingredient instanceof ScoredIngredient) {
            ScoredIngredient scoredIngredient = (ScoredIngredient)ingredient;
            ingredient = scoredIngredient.baseIngredient();
        }
        return this.recipeRegistry.isRegisteredIngredient(ingredient);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onAsyncChat(AsyncPlayerChatEvent event) {
        UUID playerUuid = event.getPlayer().getUniqueId();
        DrunkState drunkState = this.drunksManager.getDrunkState(playerUuid);
        if (drunkState == null) {
            return;
        }
        String text = event.getMessage();
        String transformed = DrunkTextTransformer.transform(text, this.drunkTextRegistry, drunkState.recalculate(TheBrewingProject.getInstance().getTime()));
        event.setMessage(transformed);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        RecipeEffects.fromItem(event.getItem()).ifPresent(effect -> effect.applyTo(event.getPlayer()));
        Ingredient ingredient = BukkitIngredientManager.INSTANCE.getIngredient(event.getItem());
        for (ConsumableSerializer.Consumable consumable : DrunkenModifierSection.modifiers().consumables()) {
            Object key;
            Object object = key = consumable.type().contains(":") ? consumable.type() : "minecraft:" + consumable.type();
            if (!ingredient.getKey().equalsIgnoreCase((String)key)) continue;
            this.drunksManager.consume(event.getPlayer().getUniqueId(), consumable.modifiers().entrySet().stream().map(entry -> new ModifierConsume(DrunkenModifierSection.modifiers().modifier((String)entry.getKey()), (Double)entry.getValue(), true)).toList());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.drunkEventExecutor.onPlayerJoinServer(event.getPlayer().getUniqueId());
        this.drunkEventExecutor.onPlayerJoinWorld(event.getPlayer().getUniqueId(), event.getPlayer().getWorld());
        this.drunksManager.planEvent(event.getPlayer().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        this.drunkEventExecutor.onPlayerJoinWorld(event.getPlayer().getUniqueId(), event.getPlayer().getWorld());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.drunkEventExecutor.onDeathExecutions(event.getPlayer().getUniqueId());
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.drunkEventExecutor.onDamage(player.getUniqueId());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerProjectileLaunch(PlayerLaunchProjectileEvent event) {
        RecipeEffects.fromItem(event.getItemStack()).ifPresent(recipeEffects -> recipeEffects.applyTo(event.getProjectile()));
    }
}

