/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.migration;

import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.recipe.QualityData;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlFile;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class Migrations {
    private static final Pattern SIMPLE_NUMBER_PATTERN = Pattern.compile("(-|)\\d+(\\.\\d+|)");

    public static void migrateAllConfigFiles(File pluginFolder) {
        Migrations.updateRecipes(new File(pluginFolder, "recipes.yml"));
        Migrations.updateIncompleteRecipes(pluginFolder);
    }

    private static void updateIncompleteRecipes(File pluginFolder) {
        File recipesFile = new File(pluginFolder, "recipes.yml");
        File incompleteRecipes = new File(pluginFolder, "incomplete-recipes.yml");
        if (!recipesFile.exists() || !incompleteRecipes.exists()) {
            return;
        }
        YamlFile recipesYaml = new YamlFile(recipesFile);
        YamlFile incompleteYaml = new YamlFile(incompleteRecipes);
        try {
            recipesYaml.load();
            incompleteYaml.load();
        }
        catch (IOException e) {
            Logger.logErr("Unable to read recipes.yml file even though it existed");
            Logger.logErr(e);
            return;
        }
        if (!recipesYaml.isConfigurationSection("default-recipes")) {
            return;
        }
        ConfigurationSection defaultRecipesSection = recipesYaml.getConfigurationSection("default-recipes");
        ConfigurationSection incompleteRecipesSection = incompleteYaml.getConfigurationSection("incomplete-recipes");
        defaultRecipesSection.getKeys(true).forEach(key -> incompleteRecipesSection.set((String)key, defaultRecipesSection.get((String)key)));
        recipesYaml.remove("default-recipes");
        try {
            incompleteYaml.save();
            recipesYaml.save();
        }
        catch (IOException e) {
            Logger.logErr("Unable to save recipes.yml or incomplete-recipes.yml.");
            Logger.logErr(e);
        }
    }

    private static void updateRecipes(File recipesFile) {
        if (!recipesFile.exists()) {
            return;
        }
        YamlFile yaml = new YamlFile(recipesFile);
        try {
            yaml.load();
        }
        catch (IOException e) {
            Logger.logErr("Unable to read recipes.yml file even though it existed");
            Logger.logErr(e);
            return;
        }
        ConfigurationSection section = yaml.getConfigurationSection("recipes");
        for (String recipeKey : section.getKeys(false)) {
            ConfigurationSection recipe = section.getConfigurationSection(recipeKey);
            for (String key : recipe.getKeys(false)) {
                if (!key.equals("alcohol")) continue;
                ConfigurationSection modifiers = recipe.createSection("modifiers");
                String alcoholString = recipe.getString("alcohol");
                String toxinsString = QualityData.toQualityFactoredString(QualityData.readQualityFactoredString(alcoholString).map(string -> string.replace("%", "")).map(Double::parseDouble).qualityMap((quality, aDouble) -> switch (quality) {
                    default -> throw new MatchException(null, null);
                    case BrewQuality.BAD -> aDouble > 0.0 ? aDouble * 2.0 / 3.0 : aDouble * 1.0 / 4.0;
                    case BrewQuality.GOOD -> aDouble * 1.0 / 2.0;
                    case BrewQuality.EXCELLENT -> aDouble > 0.0 ? aDouble * 1.0 / 4.0 : aDouble * 2.0 / 3.0;
                }).map(String::valueOf));
                if (SIMPLE_NUMBER_PATTERN.matcher(alcoholString).matches()) {
                    modifiers.set("alcohol", Double.parseDouble(alcoholString));
                } else {
                    modifiers.set("alcohol", alcoholString);
                }
                recipe.remove("alcohol");
                modifiers.set("toxins", toxinsString);
            }
        }
        try {
            yaml.save();
        }
        catch (IOException e) {
            Logger.logErr("Unable to save recipes.yml file");
            Logger.logErr(e);
        }
    }
}

