/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.Style;

public class ComponentUtil {
    public static List<Component> splitIntoLines(Component component) {
        ArrayList<Component> lines = new ArrayList<Component>();
        ArrayList<Component> currentLine = new ArrayList<Component>();
        ComponentUtil.splitRecursive(component, currentLine, lines);
        if (!currentLine.isEmpty()) {
            lines.add(Component.empty().children(currentLine));
        }
        return lines;
    }

    private static void splitRecursive(Component component, List<Component> currentLine, List<Component> lines) {
        if (component instanceof TextComponent) {
            TextComponent text = (TextComponent)component;
            String[] parts = text.content().split("\\n", -1);
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].isEmpty()) {
                    currentLine.add((Component)Component.text((String)parts[i], (Style)text.style()));
                }
                if (i >= parts.length - 1) continue;
                lines.add(Component.empty().children(currentLine));
                currentLine.clear();
            }
        } else if (component.equals((Object)Component.newline())) {
            lines.add(Component.empty().children(currentLine));
            currentLine.clear();
        } else {
            currentLine.add(component);
        }
        for (Component child : component.children()) {
            ComponentUtil.splitRecursive(child, currentLine, lines);
        }
    }
}

