/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration;

import dev.jsinco.brewery.configuration.BarrelSection;
import dev.jsinco.brewery.configuration.CauldronSection;
import dev.jsinco.brewery.configuration.SoundSection;
import dev.jsinco.brewery.lib.eu.okaeri.configs.ConfigManager;
import dev.jsinco.brewery.lib.eu.okaeri.configs.OkaeriConfig;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Comment;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.CustomKey;
import dev.jsinco.brewery.lib.eu.okaeri.configs.annotation.Exclude;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.OkaeriSerdesPack;
import dev.jsinco.brewery.lib.eu.okaeri.configs.yaml.snakeyaml.YamlSnakeYamlConfigurer;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import lombok.Generated;

public class Config
extends OkaeriConfig {
    @Comment(value={"Config version. Don't change this"})
    @CustomKey(value="config-version")
    private int configVersion = 1;
    @Comment(value={"What language file should we use? See: /TheBrewingProject/locale"})
    @CustomKey(value="language")
    private Locale language = Locale.US;
    @Comment(value={"Allow hoppers to interact with distilleries and barrels"})
    @CustomKey(value="automation-enabled")
    private boolean automation = true;
    @Comment(value={"Whether an ingredient can be added into a brew regardless if it's not in any of the recipes"})
    @CustomKey(value="allow-unregistered-ingredients")
    private boolean allowUnregisteredIngredients = false;
    @Comment(value={"Whether items should be consumed when in creative mode when using it on tbp structures"})
    @CustomKey(value="consume-items-in-creative")
    private boolean consumeItemsInCreative = false;
    @Comment(value={"Whether everything non-item related should be translated to the players locale"})
    @CustomKey(value="client-side-translations")
    private boolean clientSideTranslations = false;
    @Comment(value={"The step data is accessible for the user, enable this, if you don't want anyone cheating the system", "WARNING: Only one encryption key is allowed, switching keys will corrupt brew data"})
    @CustomKey(value="encrypt-sensitive-data")
    private boolean encryptSensitiveData = true;
    @Comment(value={"The key that is going to be used for the encryption, this is unique per server"})
    private SecretKey encryptionKey = this.generateKey();
    @CustomKey(value="cauldrons")
    private CauldronSection cauldrons = new CauldronSection();
    @CustomKey(value="barrels")
    private BarrelSection barrels = new BarrelSection();
    @Comment(value={"This field accepts either a single sound definition or a list of definitions.", "If a list is provided, one sound will be chosen randomly.", "", "A single sound entry is a string with one of the following formats", "- <sound_id>", "- <sound_id>/<pitch>", "- <sound_id>/<min_pitch>;<max_pitch>", "", "See the default values below for examples"})
    @CustomKey(value="sounds")
    private SoundSection sounds = new SoundSection();
    @CustomKey(value="command-aliases")
    @Comment(value={"The aliases for the 'tbp' command"})
    private List<String> commandAliases = List.of("brewery", "brew");
    @Exclude
    private static Config instance;

    public static void load(File dataFolder, OkaeriSerdesPack ... packs) {
        instance = ConfigManager.create(Config.class, it -> {
            it.withConfigurer(new YamlSnakeYamlConfigurer(), packs);
            it.withBindFile(new File(dataFolder, "config.yml"));
            it.withRemoveOrphans(true);
            it.saveDefaults();
            it.load(true);
        });
    }

    public static Config config() {
        return instance;
    }

    private SecretKey generateKey() {
        try {
            return KeyGenerator.getInstance("DES").generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public int configVersion() {
        return this.configVersion;
    }

    @Generated
    public Locale language() {
        return this.language;
    }

    @Generated
    public boolean automation() {
        return this.automation;
    }

    @Generated
    public boolean allowUnregisteredIngredients() {
        return this.allowUnregisteredIngredients;
    }

    @Generated
    public boolean consumeItemsInCreative() {
        return this.consumeItemsInCreative;
    }

    @Generated
    public boolean clientSideTranslations() {
        return this.clientSideTranslations;
    }

    @Generated
    public boolean encryptSensitiveData() {
        return this.encryptSensitiveData;
    }

    @Generated
    public SecretKey encryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public CauldronSection cauldrons() {
        return this.cauldrons;
    }

    @Generated
    public BarrelSection barrels() {
        return this.barrels;
    }

    @Generated
    public SoundSection sounds() {
        return this.sounds;
    }

    @Generated
    public List<String> commandAliases() {
        return this.commandAliases;
    }
}

