/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.event.step.Condition;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import lombok.NonNull;

public class ConditionSerializer
implements ObjectSerializer<Condition> {
    @Override
    public boolean supports(@NonNull Class<? super Condition> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Condition.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Condition object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        Condition condition = object;
        Objects.requireNonNull(condition);
        Condition condition2 = condition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Condition.Died.class, Condition.HasPermission.class, Condition.JoinedServer.class, Condition.JoinedWorld.class, Condition.TookDamage.class}, (Object)condition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Condition.Died died = (Condition.Died)condition2;
                data.setValue("died");
                break;
            }
            case 1: {
                Condition.HasPermission hasPermission = (Condition.HasPermission)condition2;
                data.add("has-permission", hasPermission.permission());
                break;
            }
            case 2: {
                Condition.JoinedServer joinedServer = (Condition.JoinedServer)condition2;
                data.setValue("joined-server");
                break;
            }
            case 3: {
                Condition.JoinedWorld joinedWorld = (Condition.JoinedWorld)condition2;
                data.add("joined-world", joinedWorld.worldName());
                break;
            }
            case 4: {
                Condition.TookDamage tookDamage = (Condition.TookDamage)condition2;
                data.setValue("took-damage");
            }
        }
    }

    @Override
    public Condition deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (data.isValue()) {
            return switch (data.getValue(String.class)) {
                case "died" -> new Condition.Died();
                case "joined-server", "join" -> new Condition.JoinedServer();
                case "took-damage" -> new Condition.TookDamage();
                default -> throw new IllegalArgumentException("Unknown data value: " + data.getValue(String.class));
            };
        }
        Set<String> keys = data.asMap().keySet();
        Preconditions.checkArgument((!keys.isEmpty() ? 1 : 0) != 0, (Object)"Condition can not be empty");
        Preconditions.checkArgument((keys.size() == 1 ? 1 : 0) != 0, (Object)("Condition can not be built from multiple condition types, found: " + String.valueOf(keys)));
        if (data.containsKey("has-permission")) {
            return new Condition.HasPermission(data.get("has-permission", String.class));
        }
        if (data.containsKey("joined-world")) {
            return new Condition.JoinedWorld(data.get("joined-world", String.class));
        }
        throw new IllegalArgumentException("Could not serialize from key: " + (String)keys.stream().findAny().get());
    }
}

