/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.util;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public record BreweryKey(String namespace, String key) {
    @NotNull
    public static BreweryKey parse(@NotNull String input) {
        return BreweryKey.parse(input, "brewery");
    }

    @NotNull
    public static BreweryKey parse(@NotNull String input, @NotNull String defaultNamespace) {
        String[] split = input.split(":", 2);
        if (split.length == 1) {
            return new BreweryKey(defaultNamespace, split[0].toLowerCase(Locale.ROOT));
        }
        if (split.length == 2) {
            return new BreweryKey(split[0].toLowerCase(Locale.ROOT), split[1].toLowerCase(Locale.ROOT));
        }
        throw new IllegalArgumentException("Invalid Brewery Key: " + input);
    }

    @Override
    @NotNull
    public String toString() {
        return this.namespace + ":" + this.key;
    }
}

