/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.util.BreweryKey;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public final class CustomEvent {
    private final List<EventStep> steps;
    private final Component displayName;
    private final EventProbability probability;

    public CustomEvent(List<EventStep> steps, @Nullable Component displayName, EventProbability probability) {
        this.steps = steps;
        this.displayName = displayName;
        this.probability = probability;
    }

    public Component displayName() {
        return this.displayName == null ? Component.text((String)"?") : this.displayName;
    }

    public List<EventStep> getSteps() {
        return List.copyOf(this.steps);
    }

    public EventProbability probability() {
        return this.probability;
    }

    public static class Builder {
        private final ImmutableList.Builder<EventStep> steps = new ImmutableList.Builder();
        private Component displayName;
        private EventProbability probability = EventProbability.NONE;

        public Builder addStep(EventStep step) {
            this.steps.add((Object)step);
            return this;
        }

        public Builder displayName(Component displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder probability(EventProbability probability) {
            this.probability = probability;
            return this;
        }

        public CustomEvent build() {
            ImmutableList builtSteps = this.steps.build();
            Preconditions.checkArgument((!builtSteps.isEmpty() ? 1 : 0) != 0, (Object)"Steps cannot be empty");
            return new CustomEvent((List<EventStep>)builtSteps, this.displayName, this.probability);
        }

        public Keyed build(BreweryKey key) {
            return new Keyed(this.build(), key);
        }
    }

    public record Keyed(CustomEvent event, BreweryKey key) implements DrunkEvent
    {
        @Override
        public Component displayName() {
            return this.event.displayName == null ? Component.text((String)this.key.key()) : this.event.displayName;
        }

        @Override
        public EventProbability probability() {
            return this.event.probability;
        }

        public List<EventStep> getSteps() {
            return this.event.getSteps();
        }
    }
}

