/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.event.step;

import dev.jsinco.brewery.api.event.EventStepProperty;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public record WaitStep(int durationTicks) implements EventStepProperty
{
    private static final Pattern TICKS_PATTERN = Pattern.compile("(\\d+)t");
    private static final Pattern SECONDS_PATTERN = Pattern.compile("(\\d+)s");
    private static final Pattern MINUTES_PATTERN = Pattern.compile("(\\d+)m");
    private static final Pattern HOURS_PATTERN = Pattern.compile("(\\d+)h");
    private static final Pattern ALLOWED_CHARACTERS = Pattern.compile("[tsmhdwy0-9 ]+");
    private static final Pattern DAYS_PATTERN = Pattern.compile("(\\d+)d");
    private static final Pattern WEEKS_PATTERN = Pattern.compile("(\\d+)w");
    private static final Pattern YEARS_PATTERN = Pattern.compile("(\\d+)y");
    private static final int SECONDS = 20;
    private static final int MINUTES = 1200;
    private static final int HOURS = 72000;
    private static final int DAYS = 1728000;
    private static final int WEEKS = 12096000;
    private static final int YEARS = 630720000;

    public static WaitStep parse(String duration) {
        if (!ALLOWED_CHARACTERS.matcher(duration).matches()) {
            throw new IllegalArgumentException("Invalid duration argument: " + duration);
        }
        return new WaitStep(WaitStep.parseInteger(TICKS_PATTERN, duration) + WaitStep.parseInteger(SECONDS_PATTERN, duration) * 20 + WaitStep.parseInteger(MINUTES_PATTERN, duration) * 1200 + WaitStep.parseInteger(HOURS_PATTERN, duration) * 72000 + WaitStep.parseInteger(DAYS_PATTERN, duration) * 1728000 + WaitStep.parseInteger(WEEKS_PATTERN, duration) * 12096000 + WaitStep.parseInteger(YEARS_PATTERN, duration) * 630720000);
    }

    private static int parseInteger(Pattern timeUnitPattern, String text) {
        Matcher matcher = timeUnitPattern.matcher(text);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1));
        }
        return 0;
    }
}

