/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record AgeStepImpl(Moment time, BarrelType barrelType) implements BrewingStep.Age
{
    private static final Map<PartialBrewScore.Type, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, PartialBrewScore.Type.TIME), new PartialBrewScore(0.0, PartialBrewScore.Type.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    @Override
    public AgeStepImpl withAge(Moment age) {
        return new AgeStepImpl(age, this.barrelType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherAge;
        Object object;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            object = ageStepImpl.time();
            otherAge = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherType = object = ageStepImpl.barrelType();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        return Stream.of(new PartialBrewScore(Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment())), PartialBrewScore.Type.TIME), new PartialBrewScore(barrelTypeScore, PartialBrewScore.Type.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.AGE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> maximumScores(BrewingStep other) {
        Moment otherAge;
        Object object;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            object = ageStepImpl.time();
            otherAge = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherType = object = ageStepImpl.barrelType();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        double timeScore = otherAge.moment() < this.time.moment() ? 1.0 : BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment());
        return Stream.of(new PartialBrewScore(timeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(barrelTypeScore, PartialBrewScore.Type.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

