/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record MixStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients) implements BrewingStep.Mix
{
    private static final Map<PartialBrewScore.Type, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, PartialBrewScore.Type.TIME), new PartialBrewScore(0.0, PartialBrewScore.Type.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    @Override
    public MixStepImpl withIngredients(Map<Ingredient, Integer> ingredients) {
        return new MixStepImpl(this.time, ingredients);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherTime;
        Object object;
        if (!(other instanceof MixStepImpl)) return BREW_STEP_MISMATCH;
        MixStepImpl mixStepImpl = (MixStepImpl)other;
        try {
            object = mixStepImpl.time();
            otherTime = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherIngredients = object = mixStepImpl.ingredients();
        double timeScore = BrewingStepUtil.nearbyValueScore(this.time.moment(), otherTime.moment());
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients, (Map<Ingredient, Integer>)otherIngredients);
        return Stream.of(new PartialBrewScore(timeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(ingredientsScore, PartialBrewScore.Type.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.MIX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> maximumScores(BrewingStep other) {
        Moment time1;
        Object object;
        if (!(other instanceof MixStepImpl)) return BREW_STEP_MISMATCH;
        MixStepImpl mixStepImpl = (MixStepImpl)other;
        try {
            object = mixStepImpl.time();
            time1 = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object ingredients1 = object = mixStepImpl.ingredients();
        double mixTimeScore = time1.moment() < this.time.moment() ? 1.0 : BrewingStepUtil.nearbyValueScore(this.time.moment(), time1.moment());
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients(), (Map<Ingredient, Integer>)ingredients1);
        return Stream.of(new PartialBrewScore(mixTimeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(ingredientsScore, PartialBrewScore.Type.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public Map<PartialBrewScore.Type, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }

    @Override
    public MixStepImpl withTime(Moment time) {
        return new MixStepImpl(time, this.ingredients);
    }
}

