/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.ingredient;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.api.integration.ItemIntegration;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class PluginIngredient
implements Ingredient {
    private final ItemIntegration itemIntegration;
    private final BreweryKey key;

    public PluginIngredient(BreweryKey key, ItemIntegration itemIntegration) {
        this.key = key;
        this.itemIntegration = itemIntegration;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key.toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        Component displayName = this.itemIntegration.displayName(this.key.key());
        return displayName == null ? Component.text((String)this.key.key()) : displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginIngredient that = (PluginIngredient)o;
        String thisKey = this.key.key().contains(":") ? this.key.key().split(":", 2)[1] : this.key.key();
        String thatKey = that.key.key().contains(":") ? that.key.key().split(":", 2)[1] : that.key.key();
        return Objects.equals(thisKey, thatKey) && this.itemIntegration == that.itemIntegration;
    }

    public int hashCode() {
        return Objects.hashCode(this.key);
    }
}

