/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries;

import dev.jsinco.brewery.api.breweries.InventoryAccessible;
import dev.jsinco.brewery.api.structure.SinglePositionStructure;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class BreweryRegistry {
    private final Map<BreweryLocation, SinglePositionStructure> activeSingleBlockStructures = new ConcurrentHashMap<BreweryLocation, SinglePositionStructure>();
    private final Map<StructureType, Set<InventoryAccessible<ItemStack, Inventory>>> opened = new ConcurrentHashMap<StructureType, Set<InventoryAccessible<ItemStack, Inventory>>>();
    private final Map<Inventory, InventoryAccessible<ItemStack, Inventory>> inventories = new ConcurrentHashMap<Inventory, InventoryAccessible<ItemStack, Inventory>>();

    public Optional<SinglePositionStructure> getActiveSinglePositionStructure(BreweryLocation position) {
        return Optional.ofNullable(this.activeSingleBlockStructures.get(position));
    }

    public void addActiveSinglePositionStructure(SinglePositionStructure cauldron) {
        this.activeSingleBlockStructures.put(cauldron.position(), cauldron);
    }

    public void removeActiveSinglePositionStructure(SinglePositionStructure cauldron) {
        this.activeSingleBlockStructures.remove(cauldron.position());
    }

    public Collection<SinglePositionStructure> getActiveSinglePositionStructure() {
        return this.activeSingleBlockStructures.values();
    }

    public <H extends InventoryAccessible<ItemStack, Inventory>> Collection<H> getOpened(StructureType structureType) {
        return this.opened.computeIfAbsent(structureType, ignored -> new HashSet());
    }

    public <H extends InventoryAccessible<ItemStack, Inventory>> void registerOpened(H holder) {
        StructureType structureType = this.getStructureType(holder);
        this.opened.computeIfAbsent(structureType, ignored -> new HashSet()).add(holder);
    }

    public <H extends InventoryAccessible<ItemStack, Inventory>> void unregisterOpened(H holder) {
        StructureType structureType = this.getStructureType(holder);
        this.opened.computeIfAbsent(structureType, ignored -> new HashSet()).remove(holder);
    }

    private <H> StructureType getStructureType(H holder) {
        for (StructureType structureType : dev.jsinco.brewery.api.util.BreweryRegistry.STRUCTURE_TYPE.values()) {
            if (!structureType.tClass().isInstance(holder)) continue;
            return structureType;
        }
        throw new IllegalArgumentException("Holder does not have a matching structure type!");
    }

    @Nullable
    public InventoryAccessible<ItemStack, Inventory> getFromInventory(Inventory inventory) {
        return this.inventories.get(inventory);
    }

    public void registerInventory(InventoryAccessible<ItemStack, Inventory> inventoryAccessible) {
        inventoryAccessible.getInventories().forEach(inventory -> this.inventories.put((Inventory)inventory, inventoryAccessible));
    }

    public void unregisterInventory(InventoryAccessible<ItemStack, Inventory> inventoryAccessible) {
        inventoryAccessible.getInventories().forEach(this.inventories::remove);
    }

    public void clear() {
        this.activeSingleBlockStructures.clear();
        this.opened.clear();
        this.inventories.clear();
    }
}

