/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.command.BreweryCommand;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Optional;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public class SealCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> command() {
        ArgumentBuilder sealAll = ((LiteralArgumentBuilder)Commands.literal((String)"all").executes(SealCommand::sealAll)).then(Commands.argument((String)"volume", (ArgumentType)StringArgumentType.greedyString()).executes(SealCommand::sealAll));
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"seal").then(sealAll)).then(Commands.argument((String)"volume", (ArgumentType)StringArgumentType.greedyString()).executes(SealCommand::sealOne))).then(BreweryCommand.playerBranch(argument -> {
            argument.then(sealAll);
            argument.then(Commands.argument((String)"volume", (ArgumentType)StringArgumentType.greedyString()).executes(SealCommand::sealOne));
        }))).executes(SealCommand::sealOne);
    }

    private static int sealAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player target = BreweryCommand.getPlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String volumeMessage = SealCommand.parseVolume(context);
        PlayerInventory targetInventory = target.getInventory();
        boolean oneFound = false;
        for (int i = 0; i < targetInventory.getSize(); ++i) {
            Optional<Brew> brewOptional;
            ItemStack itemStack = targetInventory.getItem(i);
            if (itemStack == null || !(brewOptional = BrewAdapter.fromItem(itemStack)).isPresent()) continue;
            oneFound = true;
            targetInventory.setItem(i, BrewAdapter.toItem(brewOptional.get(), new Brew.State.Seal(volumeMessage)));
        }
        if (oneFound) {
            MessageUtil.message((Audience)sender, "tbp.command.seal-success", new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)target.getName())});
        } else {
            MessageUtil.message((Audience)sender, "tbp.command.seal-failure", new TagResolver[0]);
        }
        return 1;
    }

    private static int sealOne(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Player target = BreweryCommand.getPlayer(context);
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        String volumeMessage = SealCommand.parseVolume(context);
        PlayerInventory targetInventory = target.getInventory();
        BrewAdapter.fromItem(targetInventory.getItemInMainHand()).map(brew -> BrewAdapter.toItem(brew, new Brew.State.Seal(volumeMessage))).ifPresentOrElse(itemStack -> {
            targetInventory.setItemInMainHand(itemStack);
            MessageUtil.message((Audience)sender, "tbp.command.seal-success", new TagResolver[]{Placeholder.unparsed((String)"player_name", (String)target.getName())});
        }, () -> MessageUtil.message((Audience)sender, "tbp.command.seal-failure", new TagResolver[0]));
        return 1;
    }

    @Nullable
    private static String parseVolume(CommandContext<CommandSourceStack> context) {
        try {
            String volumeMessage = (String)context.getArgument("volume", String.class);
            if (!volumeMessage.isBlank()) {
                TextComponent volumeMessageDeserialized = LegacyComponentSerializer.legacyAmpersand().deserialize(volumeMessage);
                return (String)MiniMessage.miniMessage().serialize((Component)volumeMessageDeserialized);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }
}

