/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.configuration.serializer;

import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.Arrays;
import lombok.NonNull;

public class BreweryLocationSerializer
implements ObjectSerializer<BreweryLocation.Uncompiled> {
    @Override
    public boolean supports(@NonNull Class<? super BreweryLocation.Uncompiled> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return BreweryLocation.Uncompiled.class == type;
    }

    @Override
    public void serialize(@NonNull BreweryLocation.Uncompiled object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(String.format("%s, %d, %d, %d", object.worldIdentifier(), object.x(), object.y(), object.z()));
    }

    @Override
    public BreweryLocation.Uncompiled deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String string = data.getValue(String.class);
        if (string == null) {
            throw new IllegalArgumentException("Can not deserialize empty node");
        }
        String[] split = (String[])Arrays.stream(string.split(",")).map(String::trim).toArray(String[]::new);
        if (split.length != 4) {
            throw new IllegalArgumentException("Expected location of format world, x, y, z");
        }
        int x = Integer.parseInt(split[1]);
        int y = Integer.parseInt(split[2]);
        int z = Integer.parseInt(split[3]);
        return new BreweryLocation.Uncompiled(x, y, z, split[0]);
    }
}

