/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.named;

import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.bukkit.util.LocationUtil;
import dev.jsinco.brewery.configuration.EventSection;
import dev.jsinco.brewery.util.MessageUtil;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TeleportNamedExecutable
implements EventPropertyExecutable {
    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        List<BreweryLocation> locations = EventSection.events().teleportDestinations().stream().flatMap(uncompiledLocation -> uncompiledLocation.stream(LocationUtil::resolveWorld)).filter(Objects::nonNull).toList();
        if (locations.isEmpty()) {
            return EventPropertyExecutable.ExecutionResult.CONTINUE;
        }
        BreweryLocation teleport = locations.get(RANDOM.nextInt(locations.size()));
        BukkitAdapter.toLocation(teleport).ifPresent(location -> {
            player.teleportAsync(location);
            MessageUtil.message((Audience)player, "tbp.events.teleport-message", BukkitMessageUtil.getPlayerTagResolver((OfflinePlayer)player));
        });
        return EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return -1;
    }
}

