/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect.step;

import dev.jsinco.brewery.api.event.EventPropertyExecutable;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.step.Condition;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConditionalStepExecutable
implements EventPropertyExecutable {
    private final Condition condition;

    public ConditionalStepExecutable(Condition condition) {
        this.condition = condition;
    }

    @Override
    @NotNull
    public EventPropertyExecutable.ExecutionResult execute(UUID contextPlayer, List<? extends EventStep> events, int index) {
        Player player = Bukkit.getPlayer((UUID)contextPlayer);
        if (player == null) {
            return EventPropertyExecutable.ExecutionResult.STOP_EXECUTION;
        }
        Condition condition = this.condition;
        Objects.requireNonNull(condition);
        Condition condition2 = condition;
        int n = 0;
        boolean cancel = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Condition.Died.class, Condition.HasPermission.class, Condition.JoinedServer.class, Condition.JoinedWorld.class, Condition.TookDamage.class}, (Object)condition2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Condition.Died died = (Condition.Died)condition2;
                if (!player.isDead()) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                Condition.HasPermission hasPermission = (Condition.HasPermission)condition2;
                if (!player.hasPermission(hasPermission.permission())) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                Condition.JoinedServer joinedServer = (Condition.JoinedServer)condition2;
                yield false;
            }
            case 3 -> {
                Condition.JoinedWorld joinedWorld = (Condition.JoinedWorld)condition2;
                if (!player.getWorld().getName().equals(joinedWorld.worldName())) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                Condition.TookDamage tookDamage = (Condition.TookDamage)condition2;
                yield true;
            }
        };
        return cancel ? EventPropertyExecutable.ExecutionResult.STOP_EXECUTION : EventPropertyExecutable.ExecutionResult.CONTINUE;
    }

    @Override
    public int priority() {
        return Integer.MIN_VALUE;
    }
}

