/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.item;

import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.ItemIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import dev.lone.itemsadder.api.CustomStack;
import dev.lone.itemsadder.api.Events.ItemsAdderLoadDataEvent;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class ItemsAdderIntegration
implements ItemIntegration,
Listener {
    private static final boolean ENABLED = ClassUtil.exists("dev.lone.itemsadder.api.CustomStack");
    private CompletableFuture<Void> initializedFuture;

    @Override
    public Optional<ItemStack> createItem(String id) {
        return Optional.of(CustomStack.getInstance((String)id)).map(CustomStack::getItemStack);
    }

    @Override
    @Nullable
    public Component displayName(String itemsAdderId) {
        CustomStack customStack = CustomStack.getInstance((String)itemsAdderId);
        return customStack == null ? null : customStack.getItemStack().effectiveName();
    }

    @Override
    @Nullable
    public String getItemId(ItemStack itemStack) {
        CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
        return customStack == null ? null : customStack.getId();
    }

    @Override
    public CompletableFuture<Void> initialized() {
        return this.initializedFuture;
    }

    @Override
    public boolean isEnabled() {
        return ENABLED;
    }

    @Override
    public String getId() {
        return "itemsadder";
    }

    @Override
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TheBrewingProject.getInstance());
        this.initializedFuture = new CompletableFuture();
    }

    @EventHandler
    public void onItemsAdderItemsLoad(ItemsAdderLoadDataEvent loadDataEvent) {
        this.initializedFuture.completeAsync(() -> null);
    }
}

