/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import dev.jsinco.brewery.bukkit.util.ColorUtil;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlFile;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import org.bukkit.inventory.ItemStack;

public class DefaultRecipeReader {
    public static Map<String, RecipeResult<ItemStack>> readDefaultRecipes(File folder) {
        Path mainDir = folder.toPath();
        YamlFile recipesFile = new YamlFile(mainDir.resolve("recipes.yml").toFile());
        try {
            recipesFile.createOrLoadWithComments();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ConfigurationSection recipesSection = recipesFile.getConfigurationSection("default-recipes");
        ImmutableMap.Builder recipes = new ImmutableMap.Builder();
        for (String recipeName : recipesSection.getKeys(false)) {
            recipes.put((Object)recipeName, (Object)DefaultRecipeReader.getDefaultRecipe(recipesSection.getConfigurationSection(recipeName)));
        }
        return recipes.build();
    }

    public static BukkitRecipeResult getDefaultRecipe(ConfigurationSection defaultRecipe) {
        return new BukkitRecipeResult.Builder().name(defaultRecipe.getString("name", "Cauldron Brew")).lore(defaultRecipe.getStringList("lore")).color(ColorUtil.parseColorString(defaultRecipe.getString("color", "BLUE"))).customModelData(defaultRecipe.getInt("custom-model-data", -1)).glint(defaultRecipe.getBoolean("glint", false)).recipeEffects(RecipeEffects.GENERIC).appendBrewInfoLore(false).build();
    }
}

