/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.bukkit.structure.BlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class StructureRegistry {
    private final Map<String, BreweryStructure> structureNames = new HashMap<String, BreweryStructure>();
    private final Map<StructureType, Map<Material, Set<BreweryStructure>>> structuresWithMaterials = new HashMap<StructureType, Map<Material, Set<BreweryStructure>>>();
    private final Map<StructureType, Set<BreweryStructure>> structures = new HashMap<StructureType, Set<BreweryStructure>>();

    public Optional<BreweryStructure> getStructure(@NotNull String key) {
        Preconditions.checkNotNull((Object)key);
        return Optional.ofNullable(this.structureNames.get(key));
    }

    public Set<BreweryStructure> getPossibleStructures(@NotNull Material material, StructureType structureType) {
        Preconditions.checkNotNull((Object)material);
        return this.structuresWithMaterials.computeIfAbsent(structureType, ignored -> new HashMap()).getOrDefault(material, Set.of());
    }

    public <T> void addStructure(@NotNull BreweryStructure structure, BlockDataMatcher<T> blockDataMatcher, T[] matcherTypes) {
        Preconditions.checkNotNull((Object)structure);
        this.structureNames.put(structure.getName(), structure);
        this.structures.computeIfAbsent(structure.getMeta(StructureMeta.TYPE), ignored -> new HashSet()).add(structure);
        for (T matcherType : matcherTypes) {
            Set<Material> possibleMaterials = blockDataMatcher.findStructureMaterials(matcherType, structure);
            Map materialStructureMap = this.structuresWithMaterials.computeIfAbsent(structure.getMeta(StructureMeta.TYPE), ignored -> new HashMap());
            possibleMaterials.forEach(material -> materialStructureMap.computeIfAbsent(material, ignored -> new HashSet()).add(structure));
        }
    }

    public void addStructure(@NotNull BreweryStructure structure) {
        Preconditions.checkNotNull((Object)structure);
        this.structureNames.put(structure.getName(), structure);
        this.structures.computeIfAbsent(structure.getMeta(StructureMeta.TYPE), ignored -> new HashSet()).add(structure);
        for (BlockData blockData : structure.getPalette()) {
            this.structuresWithMaterials.computeIfAbsent(structure.getMeta(StructureMeta.TYPE), ignored -> new HashMap()).computeIfAbsent(blockData.getMaterial(), ignored -> new HashSet()).add(structure);
        }
    }

    public Collection<BreweryStructure> getStructures(StructureType structureType) {
        return this.structures.computeIfAbsent(structureType, ignored -> new HashSet());
    }

    public void clear() {
        this.structures.clear();
        this.structureNames.clear();
        this.structuresWithMaterials.clear();
    }
}

