/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.api.effect.modifier.ModifierExpression;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.math.RangeD;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.Map;
import lombok.NonNull;

public class EventProbabilitySerializer
implements ObjectSerializer<EventProbability> {
    @Override
    public boolean supports(@NonNull Class<? super EventProbability> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return EventProbability.class == type;
    }

    @Override
    public void serialize(@NonNull EventProbability object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (object.probabilityExpression() != ModifierExpression.ZERO) {
            data.add("probability-expression", object.probabilityExpression());
        }
        if (!object.allowedRanges().isEmpty()) {
            data.add("allowed-ranges", object.allowedRanges());
        }
    }

    @Override
    public EventProbability deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        ModifierExpression expression = data.get("probability-expression", ModifierExpression.class);
        Map<String, RangeD> allowedRanges = data.getAsMap("allowed-ranges", String.class, RangeD.class);
        return new EventProbability(expression == null ? ModifierExpression.ZERO : expression, allowedRanges == null ? Map.of() : allowedRanges);
    }
}

