/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.event.CustomEventRegistry;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.HashMap;
import java.util.Set;
import lombok.NonNull;

public class EventRegistrySerializer
implements ObjectSerializer<CustomEventRegistry> {
    @Override
    public boolean supports(@NonNull Class<? super CustomEventRegistry> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return CustomEventRegistry.class == type;
    }

    @Override
    public void serialize(@NonNull CustomEventRegistry object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        HashMap<String, CustomEvent> output = new HashMap<String, CustomEvent>();
        for (CustomEvent.Keyed event : object.events()) {
            String key = event.key().namespace().equalsIgnoreCase("brewery") ? event.key().key() : event.key().toString();
            output.put(key, event.event());
        }
        data.setValue(output);
    }

    @Override
    public CustomEventRegistry deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        CustomEventRegistry output = new CustomEventRegistry();
        Set<String> children = data.asMap().keySet();
        for (String child : children) {
            try {
                output.registerCustomEvent(new CustomEvent.Keyed(data.get(child, CustomEvent.class), BreweryKey.parse(child)));
            }
            catch (IllegalArgumentException e) {
                Logger.logErr("Exception when reading custom event: " + child);
                throw new IllegalArgumentException(e);
            }
        }
        return output;
    }
}

