/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.EventStep;
import dev.jsinco.brewery.api.event.EventStepProperty;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.event.step.ApplyPotionEffect;
import dev.jsinco.brewery.api.event.step.Condition;
import dev.jsinco.brewery.api.event.step.ConditionalStep;
import dev.jsinco.brewery.api.event.step.ConditionalWaitStep;
import dev.jsinco.brewery.api.event.step.ConsumeStep;
import dev.jsinco.brewery.api.event.step.CustomEventStep;
import dev.jsinco.brewery.api.event.step.SendCommand;
import dev.jsinco.brewery.api.event.step.Teleport;
import dev.jsinco.brewery.api.event.step.WaitStep;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;

public class EventStepSerializer
implements ObjectSerializer<EventStep> {
    @Override
    public boolean supports(@NonNull Class<? super EventStep> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return EventStep.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull EventStep object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        HashMap<String, Condition> output = new HashMap<String, Condition>();
        for (EventStepProperty property : object.properties()) {
            EventStepProperty eventStepProperty;
            Objects.requireNonNull(property);
            int n = 0;
            output.putAll(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ApplyPotionEffect.class, ConditionalWaitStep.class, ConditionalStep.class, ConsumeStep.class, CustomEventStep.class, NamedDrunkEvent.class, SendCommand.class, Teleport.class, WaitStep.class}, (Object)eventStepProperty, n)) {
                case 0 -> {
                    ApplyPotionEffect applyPotionEffect = (ApplyPotionEffect)eventStepProperty;
                    yield Map.of("effect", applyPotionEffect.potionEffectName(), "duration", applyPotionEffect.durationBounds().asString(), "amplifier", applyPotionEffect.amplifierBounds().asString());
                }
                case 1 -> {
                    ConditionalWaitStep conditionalWaitStep = (ConditionalWaitStep)eventStepProperty;
                    yield Map.of("wait-condition", conditionalWaitStep.condition());
                }
                case 2 -> {
                    ConditionalStep conditionalStep = (ConditionalStep)eventStepProperty;
                    yield Map.of("if-condition", conditionalStep.condition());
                }
                case 3 -> {
                    ConsumeStep consumeStep = (ConsumeStep)eventStepProperty;
                    yield Map.of("consume", consumeStep.modifiers().entrySet().stream().collect(Collectors.toMap(entry -> ((DrunkenModifier)entry.getKey()).name(), Map.Entry::getValue)));
                }
                case 4 -> {
                    CustomEventStep customEvent = (CustomEventStep)eventStepProperty;
                    yield Map.of("event", customEvent.customEventKey().key());
                }
                case 5 -> {
                    NamedDrunkEvent namedDrunkEvent = (NamedDrunkEvent)eventStepProperty;
                    yield Map.of("named-event", namedDrunkEvent.key().key());
                }
                case 6 -> {
                    SendCommand sendCommand = (SendCommand)eventStepProperty;
                    yield Map.of("as", sendCommand.senderType().toString().toLowerCase(Locale.ROOT), "command", sendCommand.command());
                }
                case 7 -> {
                    Teleport teleport = (Teleport)eventStepProperty;
                    yield Map.of("location", teleport.location());
                }
                case 8 -> {
                    WaitStep waitStep = (WaitStep)eventStepProperty;
                    yield Map.of("wait-duration", waitStep.durationTicks() + "t");
                }
                default -> throw new IllegalArgumentException("Unsupported event step: " + String.valueOf(property));
            });
        }
        data.setValue(output);
    }

    @Override
    public EventStep deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        EventStep eventStep;
        Map<DrunkenModifier, Double> modifiers;
        String duration;
        Condition condition;
        NamedDrunkEvent namedDrunkEvent;
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        EventStep.Builder eventStepBuilder = new EventStep.Builder();
        if (data.containsKey("type") && (namedDrunkEvent = BreweryRegistry.DRUNK_EVENT.get(BreweryKey.parse(data.get("type", String.class)))) != null) {
            eventStepBuilder.addProperty(namedDrunkEvent);
        }
        if (data.containsKey("named-event")) {
            String string = data.get("named-event", String.class);
            NamedDrunkEvent namedDrunkEvent2 = BreweryRegistry.DRUNK_EVENT.get(BreweryKey.parse(string));
            Preconditions.checkArgument((namedDrunkEvent2 != null ? 1 : 0) != 0, (Object)("Unknown predefined drunk event: " + string));
            eventStepBuilder.addProperty(namedDrunkEvent2);
        }
        if (data.containsKey("event")) {
            namedDrunkEvent = BreweryRegistry.DRUNK_EVENT.get(BreweryKey.parse(data.get("event", String.class)));
            eventStepBuilder.addProperty(namedDrunkEvent != null ? namedDrunkEvent : new CustomEventStep(BreweryKey.parse(data.get("event", String.class))));
        }
        if (data.containsKey("command")) {
            SendCommand.CommandSenderType senderType = data.get("as", SendCommand.CommandSenderType.class);
            String command = data.get("command", String.class);
            Preconditions.checkArgument((command != null ? 1 : 0) != 0, (Object)"Command can not be empty");
            eventStepBuilder.addProperty(new SendCommand(command, senderType == null ? SendCommand.CommandSenderType.SERVER : senderType));
        }
        Preconditions.checkArgument((!data.containsKey("condition") || !data.containsKey("wait-condition") ? 1 : 0) != 0, (Object)"Duplicate condition types 'condition' and 'wait-condition'");
        if (data.containsKey("condition")) {
            condition = data.get("condition", Condition.class);
            Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"Condition can not be empty");
            Preconditions.checkArgument((condition.getClass() != Condition.HasPermission.class ? 1 : 0) != 0, (Object)"Unimplemented wait condition: has-permisison");
            eventStepBuilder.addProperty(new ConditionalWaitStep(condition));
        }
        if (data.containsKey("wait-condition")) {
            condition = data.get("wait-condition", Condition.class);
            Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"Condition can not be empty");
            Preconditions.checkArgument((condition.getClass() != Condition.HasPermission.class ? 1 : 0) != 0, (Object)"Unimplemented wait condition: has-permisison");
            eventStepBuilder.addProperty(new ConditionalWaitStep(condition));
        }
        if (data.containsKey("if-condition")) {
            condition = data.get("if-condition", Condition.class);
            Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"Condition can not be empty");
            eventStepBuilder.addProperty(new ConditionalStep(condition));
        }
        if (data.containsKey("duration") && !data.containsKey("effect")) {
            duration = data.get("duration", String.class);
            Preconditions.checkArgument((duration != null ? 1 : 0) != 0, (Object)"Duration can not be empty");
            eventStepBuilder.addProperty(WaitStep.parse(duration));
        }
        if (data.containsKey("wait-duration")) {
            duration = data.get("wait-duration", String.class);
            Preconditions.checkArgument((duration != null ? 1 : 0) != 0, (Object)"Duration can not be empty");
            eventStepBuilder.addProperty(WaitStep.parse(duration));
        }
        if (data.containsKey("effect")) {
            String effect = data.get("effect", String.class);
            Interval amplifier = data.get("amplifier", Interval.class);
            Interval duration2 = data.get("duration", Interval.class);
            eventStepBuilder.addProperty(new ApplyPotionEffect(effect, amplifier == null ? new Interval(1L, 1L) : amplifier, duration2 == null ? new Interval(200L, 200L) : duration2));
        }
        if (data.containsKey("location")) {
            BreweryLocation.Uncompiled breweryLocation = data.get("location", BreweryLocation.Uncompiled.class);
            Preconditions.checkArgument((breweryLocation != null ? 1 : 0) != 0, (Object)"Location can not be empty");
            eventStepBuilder.addProperty(new Teleport(breweryLocation));
        }
        if (data.containsKey("consume")) {
            modifiersData = data.getAsMap("consume", String.class, Double.class);
            modifiers = DrunkenModifierSection.modifiers().drunkenModifiers().stream().filter(modifier -> modifiersData.containsKey(modifier.name())).collect(Collectors.toUnmodifiableMap(modifier -> modifier, modifier -> (Double)modifiersData.get(modifier.name())));
        } else {
            modifiersData = data.asMap();
            modifiers = DrunkenModifierSection.modifiers().drunkenModifiers().stream().filter(modifier -> modifiersData.containsKey(modifier.name()) && modifiersData.get(modifier.name()) instanceof Number).collect(Collectors.toUnmodifiableMap(modifier -> modifier, modifier -> data.get(modifier.name(), Double.class)));
        }
        if (!modifiers.isEmpty()) {
            eventStepBuilder.addProperty(new ConsumeStep(modifiers));
        }
        if ((eventStep = eventStepBuilder.build()).properties().isEmpty()) {
            throw new IllegalArgumentException("Unknown step type");
        }
        return eventStep;
    }
}

