/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import lombok.NonNull;

public class NamedDrunkEventSerializer
implements ObjectSerializer<NamedDrunkEvent> {
    @Override
    public boolean supports(@NonNull Class<? super NamedDrunkEvent> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return type == NamedDrunkEvent.class;
    }

    @Override
    public void serialize(@NonNull NamedDrunkEvent object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.add("name", object.key().key());
        if (object.probability() != EventProbability.NONE) {
            data.add("probability", object.probability());
        }
    }

    @Override
    public NamedDrunkEvent deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String name = data.get("name", String.class);
        EventProbability probability = data.get("probability", EventProbability.class);
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Unknown event type, missing name key");
        return new NamedDrunkEvent(name, probability == null ? EventProbability.NONE : probability);
    }
}

