/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.Base64;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import lombok.NonNull;

public class SecretKeySerializer
implements ObjectSerializer<SecretKey> {
    @Override
    public boolean supports(@NonNull Class<? super SecretKey> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SecretKey.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull SecretKey object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(Base64.getEncoder().encodeToString(object.getEncoded()));
    }

    @Override
    public SecretKey deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String base64 = data.getValue(String.class);
        byte[] bytes = Base64.getDecoder().decode(base64);
        return new SecretKeySpec(bytes, 0, bytes.length, "des");
    }
}

