/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.effect.text;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.text.DrunkTextElement;
import dev.jsinco.brewery.effect.text.DrunkTextPattern;
import dev.jsinco.brewery.effect.text.SingleDrunkTextElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class DrunkTextRegistry {
    List<DrunkTextElement> drunkenTexts = new ArrayList<DrunkTextElement>();

    public void load(InputStream inputStream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            JsonArray jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            for (JsonElement element : jsonArray) {
                JsonObject jsonObject = element.getAsJsonObject();
                String replace = jsonObject.has("from") ? jsonObject.get("from").getAsString() : null;
                String replacement = jsonObject.get("to").getAsString();
                int percentage = jsonObject.get("percentage").getAsInt();
                Optional<DrunkenModifier> optionalModifier = DrunkenModifierSection.modifiers().drunkenModifiers().stream().filter(modifier -> jsonObject.has(modifier.name())).findAny();
                if (percentage < 0 || percentage > 100) {
                    Logger.logErr("Percentage outside range for element: " + String.valueOf(jsonObject));
                    continue;
                }
                double modifierValue = optionalModifier.map(DrunkenModifier::name).map(arg_0 -> ((JsonObject)jsonObject).get(arg_0)).map(JsonElement::getAsDouble).orElse(0.0);
                Record drunkTextElement = replace != null ? new DrunkTextPattern(Pattern.compile(replace, 2), replacement, percentage, optionalModifier.orElse(null), modifierValue) : new SingleDrunkTextElement(replacement, percentage, optionalModifier.orElse(null), modifierValue);
                this.drunkenTexts.add((DrunkTextElement)((Object)drunkTextElement));
            }
        }
    }

    public List<DrunkTextElement> getTextTransformers(Map<DrunkenModifier, Double> alcohol) {
        return this.drunkenTexts.stream().filter(drunkTextElement -> (Double)alcohol.get(drunkTextElement.modifier()) < drunkTextElement.minValue()).toList();
    }

    public void clear() {
        this.drunkenTexts.clear();
    }
}

