/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class RandomUtil {
    private static final Random RANDOM = new Random();

    public static <T> T randomWeighted(List<T> tList, Function<T, Double> toWeight) {
        double[] cumulativeSums = new double[tList.size()];
        double cumulativeSum = 0.0;
        for (int i = 0; i < tList.size(); ++i) {
            T t = tList.get(i);
            cumulativeSums[i] = cumulativeSum += toWeight.apply(t).doubleValue();
        }
        double randomInt = RANDOM.nextDouble(cumulativeSum);
        for (int i = 0; i < tList.size(); ++i) {
            if (!(cumulativeSums[i] > randomInt)) continue;
            return tList.get(i);
        }
        return tList.getLast();
    }
}

