/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.brew.PartialBrewScore;
import dev.jsinco.brewery.breweries.BarrelType;
import dev.jsinco.brewery.moment.Moment;
import java.util.List;

public record AgeStepImpl(Moment time, BarrelType barrelType) implements BrewingStep.Age
{
    private static final List<PartialBrewScore> BREW_STEP_MISMATCH = List.of(new PartialBrewScore(0.0, PartialBrewScore.Type.TIME), new PartialBrewScore(0.0, PartialBrewScore.Type.BARREL_TYPE));

    @Override
    public AgeStepImpl withAge(Moment age) {
        return new AgeStepImpl(age, this.barrelType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherAge;
        Object object;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            object = ageStepImpl.time();
            otherAge = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherType = object = ageStepImpl.barrelType();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        return List.of(new PartialBrewScore(Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment())), PartialBrewScore.Type.TIME), new PartialBrewScore(barrelTypeScore, PartialBrewScore.Type.BARREL_TYPE));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.AGE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PartialBrewScore> maximumScores(BrewingStep other) {
        Moment otherAge;
        Object object;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            object = ageStepImpl.time();
            otherAge = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object otherType = object = ageStepImpl.barrelType();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        double timeScore = otherAge.moment() < this.time.moment() ? 1.0 : BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment());
        return List.of(new PartialBrewScore(timeScore, PartialBrewScore.Type.TIME), new PartialBrewScore(barrelTypeScore, PartialBrewScore.Type.BARREL_TYPE));
    }

    @Override
    public List<PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

