/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.brew.PartialBrewScore;
import java.util.List;

public record DistillStepImpl(int runs) implements BrewingStep.Distill
{
    private static final List<PartialBrewScore> BREW_STEP_MISMATCH = List.of(new PartialBrewScore(0.0, PartialBrewScore.Type.DISTILL_AMOUNT));

    @Override
    public DistillStepImpl incrementAmount() {
        return new DistillStepImpl(this.runs + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PartialBrewScore> proximityScores(BrewingStep other) {
        int otherRuns;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            otherRuns = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        double distillScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.runs, otherRuns));
        return List.of(new PartialBrewScore(distillScore, PartialBrewScore.Type.DISTILL_AMOUNT));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.DISTILL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<PartialBrewScore> maximumScores(BrewingStep other) {
        int runs1;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            runs1 = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        double maximumDistillScore = runs1 < this.runs ? 1.0 : BrewingStepUtil.nearbyValueScore(this.runs, runs1);
        return List.of(new PartialBrewScore(maximumDistillScore, PartialBrewScore.Type.DISTILL_AMOUNT));
    }

    @Override
    public List<PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }
}

