/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.brew;

import dev.jsinco.brewery.brew.Brew;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.BrewQuality;
import dev.jsinco.brewery.brew.BrewScore;
import dev.jsinco.brewery.brew.BrewingStep;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.util.BukkitAdapter;
import dev.jsinco.brewery.bukkit.util.IngredientUtil;
import dev.jsinco.brewery.bukkit.util.ListPersistentDataType;
import dev.jsinco.brewery.configuration.locale.TranslationsConfig;
import dev.jsinco.brewery.ingredient.Ingredient;
import dev.jsinco.brewery.ingredient.IngredientManager;
import dev.jsinco.brewery.recipe.Recipe;
import dev.jsinco.brewery.recipe.RecipeRegistry;
import dev.jsinco.brewery.recipe.RecipeResult;
import dev.jsinco.brewery.recipes.BrewScoreImpl;
import dev.jsinco.brewery.recipes.RecipeRegistryImpl;
import dev.jsinco.brewery.util.BreweryKey;
import dev.jsinco.brewery.util.MessageUtil;
import dev.jsinco.brewery.util.Pair;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class BrewAdapter {
    private static final int DATA_VERSION = 0;
    private static final NamespacedKey BREWING_STEPS = BukkitAdapter.toNamespacedKey(BreweryKey.parse("steps"));
    private static final NamespacedKey BREWERY_DATA_VERSION = BukkitAdapter.toNamespacedKey(BreweryKey.parse("version"));
    public static final NamespacedKey BREWERY_TAG = BukkitAdapter.toNamespacedKey(BreweryKey.parse("tag"));
    public static final NamespacedKey BREWERY_SCORE = BukkitAdapter.toNamespacedKey(BreweryKey.parse("score"));
    public static final NamespacedKey BREWERY_DISPLAY_NAME = BukkitAdapter.toNamespacedKey(BreweryKey.parse("display_name"));

    public static ItemStack toItem(Brew brew, Brew.State state) {
        ItemStack itemStack;
        RecipeRegistry recipeRegistry = TheBrewingProject.getInstance().getRecipeRegistry();
        Optional recipe = brew.closestRecipe(recipeRegistry);
        Optional<BrewScore> score = recipe.map(brew::score);
        Optional quality = score.flatMap(brewScore -> Optional.ofNullable(brewScore.brewQuality()));
        if (quality.isEmpty()) {
            RecipeResult randomDefault = ((RecipeRegistryImpl)recipeRegistry).getRandomDefaultRecipe();
            itemStack = (ItemStack)randomDefault.newBrewItem(BrewScoreImpl.EXCELLENT, brew, state);
        } else if (!score.map(BrewScore::completed).get().booleanValue()) {
            itemStack = BrewAdapter.incompletePotion(brew);
        } else {
            RecipeResult recipeResult = recipe.get().getRecipeResult((BrewQuality)((Object)quality.get()));
            itemStack = (ItemStack)recipeResult.newBrewItem(score.get(), brew, state);
            itemStack.editPersistentDataContainer(pdc -> {
                pdc.set(BREWERY_TAG, PersistentDataType.STRING, (Object)BreweryKey.parse(((Recipe)recipe.get()).getRecipeName()).toString());
                pdc.set(BREWERY_SCORE, PersistentDataType.DOUBLE, (Object)((BrewScore)score.get()).score());
                if (recipeResult instanceof BukkitRecipeResult) {
                    BukkitRecipeResult bukkitRecipeResult = (BukkitRecipeResult)recipeResult;
                    pdc.set(BREWERY_DISPLAY_NAME, PersistentDataType.STRING, (Object)bukkitRecipeResult.getName());
                }
            });
        }
        if (!(state instanceof Brew.State.Seal)) {
            itemStack.editPersistentDataContainer(pdc -> BrewAdapter.fillPersistentData(pdc, brew));
        }
        return itemStack;
    }

    private static ItemStack incompletePotion(Brew brew) {
        ItemStack itemStack = new ItemStack(Material.POTION);
        itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)((TooltipDisplay)TooltipDisplay.tooltipDisplay().hiddenComponents(Registry.DATA_COMPONENT_TYPE.stream().filter(dataComponentType -> dataComponentType != DataComponentTypes.LORE).collect(Collectors.toSet())).build()));
        HashMap<Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>();
        for (BrewingStep brewingStep : brew.getCompletedSteps()) {
            if (brewingStep instanceof BrewingStep.Cook) {
                BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep;
                IngredientManager.merge(ingredients, cook.ingredients());
            }
            if (!(brewingStep instanceof BrewingStep.Mix)) continue;
            BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep;
            IngredientManager.merge(ingredients, mix.ingredients());
        }
        Pair<Color, Ingredient> itemsInfo = IngredientUtil.ingredientData(ingredients);
        Ingredient topIngredient = itemsInfo.second();
        Map<BrewingStep.StepType, String> displayNameByStep = Map.of(BrewingStep.StepType.COOK, topIngredient == null ? TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_FERMENTED_UNKNOWN : TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_FERMENTED, BrewingStep.StepType.DISTILL, topIngredient == null ? TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_DISTILLED_UNKNOWN : TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_DISTILLED, BrewingStep.StepType.AGE, topIngredient == null ? TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_AGED_UNKNOWN : TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_AGED, BrewingStep.StepType.MIX, topIngredient == null ? TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_MIXED_UNKNOWN : TranslationsConfig.BREW_DISPLAY_NAME_UNFINISHED_MIXED);
        BrewingStep.StepType lastStep = brew.getCompletedSteps().getLast().stepType();
        Component displayName = topIngredient == null ? MessageUtil.miniMessage(displayNameByStep.get((Object)lastStep), new TagResolver[0]) : MessageUtil.miniMessage(displayNameByStep.get((Object)lastStep), new TagResolver[]{Placeholder.component((String)"ingredient", (ComponentLike)topIngredient.displayName())});
        itemStack.setData(DataComponentTypes.CUSTOM_NAME, (Object)displayName.decoration(TextDecoration.ITALIC, false));
        itemStack.setData(DataComponentTypes.POTION_CONTENTS, (Object)((PotionContents)PotionContents.potionContents().customColor(itemsInfo.first()).build()));
        return itemStack;
    }

    private static void fillPersistentData(PersistentDataContainer pdc, Brew brew) {
        pdc.set(BREWING_STEPS, ListPersistentDataType.BREWING_STEP_LIST, brew.getSteps());
        pdc.set(BREWERY_DATA_VERSION, PersistentDataType.INTEGER, (Object)0);
    }

    public static Optional<Brew> fromItem(ItemStack itemStack) {
        PersistentDataContainerView data = itemStack.getPersistentDataContainer();
        Integer dataVersion = (Integer)data.get(BREWERY_DATA_VERSION, PersistentDataType.INTEGER);
        if (!Objects.equals(dataVersion, 0)) {
            return Optional.empty();
        }
        return Optional.ofNullable((List)data.get(BREWING_STEPS, ListPersistentDataType.BREWING_STEP_LIST)).map(BrewImpl::new);
    }
}

